/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl;

import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl.CustomNimbusRequestParser;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.slf4j.Logger;

public abstract class BaseOAuth2RequestDecoder<T extends Request>
extends AbstractHttpServletRequestMessageDecoder {
    @Nonnull
    private static final Logger log = LoggerFactory.getLogger(BaseOAuth2RequestDecoder.class);
    private boolean removeIpAddressFromEndpointUri;
    @Nullable
    protected CustomNimbusRequestParser<T> customRequestParser;

    public BaseOAuth2RequestDecoder() {
        this.setProtocolMessageLoggerSubCategory("OAUTH2");
    }

    public synchronized void setRemoveIpAddressFromEndpointUri(boolean flag) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.removeIpAddressFromEndpointUri = flag;
    }

    public synchronized void setCustomRequestParser(@Nullable CustomNimbusRequestParser<T> customParser) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.customRequestParser = customParser;
    }

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        HttpServletRequest httpServletRequest = this.getHttpServletRequest();
        assert (httpServletRequest != null);
        T requestMessage = this.customRequestParser != null ? this.customRequestParser.parse(httpServletRequest) : this.parseMessage();
        messageContext.setMessage(requestMessage);
        this.setMessageContext(messageContext);
    }

    @Nullable
    protected abstract T parseMessage() throws MessageDecodingException;

    @Nullable
    protected abstract String getMessageToLog(T var1);

    @Nullable
    protected String serializeMessageForLogging(@Nullable Object message) {
        return this.getMessageToLog((Request)message);
    }

    @Nullable
    protected String getEndpointURI(Request message) {
        if (this.removeIpAddressFromEndpointUri) {
            HttpServletRequest httpServletRequest = this.getHttpServletRequest();
            return httpServletRequest != null ? httpServletRequest.getRequestURI() : null;
        }
        URI endpointUri = message.getEndpointURI();
        return endpointUri != null ? endpointUri.toString() : null;
    }

    protected void switchIntoCustomResource(@Nonnull HTTPRequest httpRequest) {
        String body = httpRequest.getQuery();
        if (body != null) {
            httpRequest.setQuery(BaseOAuth2RequestDecoder.transformResourceParameter(body));
        }
    }

    @Nullable
    public static String transformResourceParameter(@Nullable String string) {
        Object input = string;
        if (input == null || !((String)input).contains("resource=")) {
            return input;
        }
        String customParameterPrefix = "urn:shibboleth.oidc.op.resource:";
        if (((String)input).startsWith("resource=")) {
            input = "resource=urn:shibboleth.oidc.op.resource:" + ((String)input).substring("resource=".length());
        }
        input = ((String)input).replace("&resource=", "&resource=urn:shibboleth.oidc.op.resource:");
        log.debug("Returning modified string {}", input);
        return input;
    }
}

