/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.PushedAuthorizationRequest;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.AbstractAuthorizationRequestLookupFunction;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultRequestedPromptLookupFunction
extends AbstractAuthorizationRequestLookupFunction<Prompt> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestedPromptLookupFunction.class);

    @Override
    @Nullable
    protected Prompt doLookup(@Nonnull AuthorizationRequest req, @Nullable PushedAuthorizationRequest parRequest, @Nullable JWT requestObject, boolean isRequestObjectFromPar) {
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim("prompt") != null) {
                return Prompt.parse((String)requestObject.getJWTClaimsSet().getStringClaim("prompt"));
            }
        }
        catch (ParseException | java.text.ParseException e) {
            this.log.error("Unable to parse prompt from request object prompt value");
            return null;
        }
        if (req.getPrompt() == null) {
            return null;
        }
        Prompt requestParameterPrompt = new Prompt();
        requestParameterPrompt.addAll((Collection)req.getPrompt());
        return this.checkRequestObject(req, isRequestObjectFromPar, "prompt", requestParameterPrompt, null);
    }
}

