/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.PushedAuthorizationRequest;
import com.nimbusds.oauth2.sdk.ResponseType;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.AbstractAuthorizationRequestLookupFunction;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultRequestResponseTypeLookupFunction
extends AbstractAuthorizationRequestLookupFunction<ResponseType> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestResponseTypeLookupFunction.class);

    @Override
    @Nullable
    protected ResponseType doLookup(@Nonnull AuthorizationRequest req, @Nullable PushedAuthorizationRequest parRequest, @Nullable JWT requestObject, boolean isRequestObjectFromPar) {
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim("response_type") != null) {
                return ResponseType.parse((String)requestObject.getJWTClaimsSet().getStringClaim("response_type"));
            }
        }
        catch (ParseException | java.text.ParseException e) {
            this.log.error("Unable to parse response type from request object response_type value {}", (Object)e.getMessage());
            return null;
        }
        ResponseType requestedType = req.getResponseType();
        ResponseType result = new ResponseType();
        if (requestedType != null) {
            result.addAll((Collection)requestedType);
        }
        return this.checkRequestObject(req, isRequestObjectFromPar, "response_type", result, new ResponseType());
    }
}

