/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.PushedAuthorizationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import java.text.ParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.AbstractAuthenticationRequestLookupFunction;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultRequestNonceLookupFunction
extends AbstractAuthenticationRequestLookupFunction<Nonce> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestNonceLookupFunction.class);

    @Override
    @Nullable
    protected Nonce doLookup(@Nonnull AuthenticationRequest req, @Nullable PushedAuthorizationRequest parRequest, @Nullable JWT requestObject, boolean isRequestObjectFromPar) {
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim("nonce") != null) {
                Object nonce = requestObject.getJWTClaimsSet().getClaim("nonce");
                if (nonce instanceof String) {
                    String string = (String)nonce;
                    return new Nonce(string);
                }
                this.log.error("nonce claim is not of expected type");
                return null;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse nonce from request object nonce value");
            return null;
        }
        if (req.getNonce() != null) {
            return this.checkRequestObject((AuthorizationRequest)req, isRequestObjectFromPar, "nonce", new Nonce(req.getNonce().getValue()), null);
        }
        return null;
    }
}

