/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.logout.profile.impl;

import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.logout.profile.impl.AbstractOIDCLogoutPropagationAction;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCLogoutPropagationContext;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultChainRevocationLifetimeLookupStrategy;
import net.shibboleth.idp.plugin.oidc.op.session.OIDCRPSession;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.RevocationCache;
import org.slf4j.Logger;

public class RevokeTokenChain
extends AbstractOIDCLogoutPropagationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RevokeTokenChain.class);
    @NonnullAfterInit
    private RevocationCache revocationCache;
    @Nonnull
    private Function<ProfileRequestContext, Duration> chainRevocationLifetimeLookupStrategy = new DefaultChainRevocationLifetimeLookupStrategy();
    @Nullable
    private Duration revocationLifetime;
    @Nullable
    private String rootTokenIdentifier;

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        this.checkSetterPreconditions();
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    public void setChainRevocationLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.checkSetterPreconditions();
        this.chainRevocationLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.revocationLifetime = this.chainRevocationLifetimeLookupStrategy.apply(profileRequestContext);
        if (this.revocationLifetime == null || Duration.ZERO.equals(this.revocationLifetime)) {
            this.log.error("{} Unable to obtain revocation lifetime to use", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        OIDCRPSession rpSession = this.getOidcRPSession();
        assert (rpSession != null);
        this.rootTokenIdentifier = rpSession.getRootTokenIdentifier();
        if (this.rootTokenIdentifier == null) {
            this.log.debug("{} OIDCRPSession context did not contain a root jti, nothing to revoke.", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCLogoutPropagationContext oidcLogoutPropContext = this.getOidcLogoutContext();
        assert (oidcLogoutPropContext != null);
        assert (this.rootTokenIdentifier != null);
        assert (this.revocationLifetime != null);
        if (this.revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, this.rootTokenIdentifier, this.revocationLifetime)) {
            oidcLogoutPropContext.setRevocationError(false);
            this.log.debug("{} Revoked all tokens based on ID '{}'", (Object)this.getLogPrefix(), (Object)this.rootTokenIdentifier);
        } else {
            oidcLogoutPropContext.setRevocationError(true);
            this.log.warn("{} Failed to revoke tokens based on ID '{}'", (Object)this.getLogPrefix(), (Object)this.rootTokenIdentifier);
        }
    }
}

