/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.logout.profile.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.JWTID;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.claims.LogoutTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.SessionID;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.encoding.impl.ResponseUtil;
import net.shibboleth.idp.plugin.oidc.op.logout.profile.impl.AbstractOIDCBackChannelLogoutPropagationAction;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCBackChannelLogoutPropagationContext;
import net.shibboleth.idp.plugin.oidc.op.session.OIDCRPSession;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PrepareBackChannelLogoutRequest
extends AbstractOIDCBackChannelLogoutPropagationAction {
    @Nonnull
    private static final Logger log = LoggerFactory.getLogger(PrepareBackChannelLogoutRequest.class);
    @Nonnull
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE.OIDC");
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    private boolean xmlSafeIdentifier = true;

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        this.checkSetterPreconditions();
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Identifier generation strategy cannot be null");
    }

    public void setXmlSafeIdentifier(boolean flag) {
        this.checkSetterPreconditions();
        this.xmlSafeIdentifier = flag;
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            log.error("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCRPSession rpSession = this.getOidcRPSession();
        assert (rpSession != null);
        Issuer iss = new Issuer(rpSession.getIssuer());
        Subject sub = new Subject(rpSession.getSubject());
        List<Audience> aud = Collections.singletonList(new Audience(rpSession.getId()));
        Date iat = Calendar.getInstance().getTime();
        assert (this.idGenerator != null);
        JWTID jti = new JWTID(this.idGenerator.generateIdentifier(this.xmlSafeIdentifier));
        SessionID sid = new SessionID(rpSession.getSessionIdentifier());
        LogoutTokenClaimsSet logoutTokenClaimsSet = new LogoutTokenClaimsSet(iss, sub, aud, iat, jti, sid);
        OIDCBackChannelLogoutPropagationContext bcLogoutContext = this.getOidcBackChannelLogoutContext();
        assert (bcLogoutContext != null);
        bcLogoutContext.setLogoutTokenClaimsSet(logoutTokenClaimsSet);
        try {
            assert (this.objectMapper != null);
            this.protocolMessageLog.trace("Logout token payload contents:\n{}", (Object)ResponseUtil.getLogoutTokenProtocolMessage(logoutTokenClaimsSet, this.objectMapper));
        }
        catch (ParseException e) {
            log.error("{} Could not produce the protocol logger message", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
        }
    }
}

