/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.logout.profile.impl;

import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.logout.profile.impl.AbstractOIDCRpInitiatedLogoutAction;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCRpInitiatedLogoutContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.impl.RpInitiatedLogoutResponse;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class FormRpInitiatedLogoutResponse
extends AbstractOIDCRpInitiatedLogoutAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(FormRpInitiatedLogoutResponse.class);
    @Nullable
    private URI postLogoutRedirectUri;
    @Nullable
    private String state;

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        OIDCRpInitiatedLogoutContext rpInitiatedLogoutContext = this.getRpInitiatedLogoutContext();
        assert (rpInitiatedLogoutContext != null);
        this.postLogoutRedirectUri = rpInitiatedLogoutContext.getPostLogoutRedirectUri();
        if (this.postLogoutRedirectUri == null) {
            this.log.debug("{} No post logout redirection URI set in the context", (Object)this.getLogPrefix());
        }
        this.state = rpInitiatedLogoutContext.getState();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RpInitiatedLogoutResponse response;
        if (this.postLogoutRedirectUri != null) {
            String uri = this.postLogoutRedirectUri.toString();
            response = this.state == null ? new RpInitiatedLogoutResponse(uri) : new RpInitiatedLogoutResponse(uri, this.state);
        } else {
            response = new RpInitiatedLogoutResponse(null);
        }
        profileRequestContext.ensureOutboundMessageContext().setMessage((Object)response);
    }
}

