/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.decoding.impl;

import com.google.common.base.MoreObjects;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.JakartaServletUtils;
import com.nimbusds.openid.connect.sdk.LogoutRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.RequestUtil;
import net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl.BaseOAuth2RequestDecoder;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.slf4j.Logger;

public class OIDCLogoutRequestDecoder
extends BaseOAuth2RequestDecoder<LogoutRequest> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCLogoutRequestDecoder.class);

    @Override
    @Nonnull
    protected LogoutRequest parseMessage() throws MessageDecodingException {
        try {
            HTTPRequest httpReq = JakartaServletUtils.createHTTPRequest((HttpServletRequest)this.getHttpServletRequest());
            this.getProtocolMessageLogger().trace("Inbound request {}", (Object)RequestUtil.toString(httpReq));
            LogoutRequest logoutRequest = LogoutRequest.parse((HTTPRequest)httpReq);
            if (logoutRequest == null) {
                throw new MessageDecodingException("LogoutRequest could not be parsed");
            }
            return logoutRequest;
        }
        catch (ParseException | IOException e) {
            this.log.error("Unable to decode inbound request: {}", (Object)e.getMessage());
            throw new MessageDecodingException((Exception)e);
        }
    }

    @Override
    @Nullable
    protected String getMessageToLog(@Nullable LogoutRequest message) {
        return message == null ? null : MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("logoutHint", (Object)message.getLogoutHint()).add("clientId", (Object)message.getClientID()).add("endpointURI", (Object)this.getEndpointURI((Request)message)).add("idTokenHint", message.getIDTokenHint() == null ? null : message.getIDTokenHint().serialize()).add("postLogoutRedirectionUri", (Object)message.getPostLogoutRedirectionURI()).add("state", (Object)message.getState()).add("uiLocales", (Object)message.getUILocales()).toString();
    }
}

