/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.decoding.impl;

import com.google.common.base.MoreObjects;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.JakartaServletUtils;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.RequestUtil;
import net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl.BaseOAuth2RequestDecoder;
import net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl.CustomResourceHttpServletRequestWrapper;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.slf4j.Logger;

public class OIDCAuthenticationRequestDecoder
extends BaseOAuth2RequestDecoder<AuthenticationRequest> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCAuthenticationRequestDecoder.class);

    @Override
    protected AuthenticationRequest parseMessage() throws MessageDecodingException {
        try {
            HttpServletRequest httpServletRequest = this.getHttpServletRequest();
            if (httpServletRequest != null) {
                this.getProtocolMessageLogger().trace("Inbound request {}", (Object)RequestUtil.toString(JakartaServletUtils.createHTTPRequest((HttpServletRequest)httpServletRequest)));
                CustomResourceHttpServletRequestWrapper httpServletRequestWrapper = new CustomResourceHttpServletRequestWrapper(httpServletRequest);
                HTTPRequest httpReq = JakartaServletUtils.createHTTPRequest((HttpServletRequest)httpServletRequestWrapper);
                if (httpReq != null) {
                    return AuthenticationRequest.parse((HTTPRequest)httpReq);
                }
            }
            throw new MessageDecodingException("Could not create HTTPRequest object from the incoming request");
        }
        catch (ParseException | IOException e) {
            this.log.error("Unable to decode inbound request: {}", (Object)e.getMessage());
            throw new MessageDecodingException((Exception)e);
        }
    }

    @Override
    protected String getMessageToLog(@Nullable AuthenticationRequest message) {
        return message == null ? null : MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("maxAge", message.getMaxAge()).add("acrValues", (Object)message.getACRValues()).add("claimsLocales", (Object)message.getClaimsLocales()).add("clientId", (Object)message.getClientID()).add("codeChallenge", (Object)message.getCodeChallenge()).add("codeChallengeMethod", (Object)message.getCodeChallengeMethod()).add("customParameters", (Object)message.getCustomParameters()).add("display", (Object)message.getDisplay()).add("endpointURI", (Object)this.getEndpointURI((Request)message)).add("idTokenHint", message.getIDTokenHint() == null ? null : message.getIDTokenHint().serialize()).add("loginHint", (Object)message.getLoginHint()).add("nonce", (Object)message.getNonce()).add("oidcClaims", (Object)message.getOIDCClaims()).add("prompt", (Object)message.getPrompt()).add("purpose", (Object)message.getPurpose()).add("redirectionURI", (Object)message.getRedirectionURI()).add("requestObject", message.getRequestObject() == null ? null : message.getRequestObject().serialize()).add("requestURI", (Object)message.getRequestURI()).add("resources", (Object)message.getResources()).add("responseMode", (Object)message.getResponseMode()).add("responseType", (Object)message.getResponseType()).add("scope", (Object)message.getScope()).add("state", (Object)message.getState()).add("uiLocales", (Object)message.getUILocales()).toString();
    }
}

