/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.token.support;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.time.Instant;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.primitive.StringSupport;

public final class RegistrationClaimsSet {
    private static final String VALUE_TYPE_RT = "rt";
    @JsonProperty(value="jti")
    @Nullable
    @NotEmpty
    private String jti;
    @JsonProperty(value="type")
    @Nullable
    @NotEmpty
    private String keyType;
    @JsonProperty(value="iss")
    @Nullable
    @NotEmpty
    private String issuer;
    @JsonProperty(value="exp")
    @Nullable
    private Instant expiration;
    @JsonProperty(value="iat")
    @Nullable
    private Instant issuedAt;
    @JsonProperty(value="prncpl")
    @Nullable
    @NotEmpty
    private String principal;
    @JsonProperty(value="acr")
    @Nullable
    @NotEmpty
    private String authContext;
    @JsonProperty(value="auth_time")
    @Nullable
    private Instant authTime;
    @JsonProperty(value="metadata")
    @Nullable
    @NonnullElements
    private Map<String, MetadataPolicy> metadata;
    @JsonProperty(value="rp_id")
    @Nullable
    @NotEmpty
    private String relyingPartyId;
    @JsonProperty(value="client_id")
    @Nullable
    @NotEmpty
    private String clientId;
    @JsonProperty(value="replacement")
    @Nullable
    private Boolean replacement;

    private RegistrationClaimsSet() {
    }

    @Nullable
    @NotEmpty
    public String getJti() {
        return this.jti;
    }

    public void setJti(@Nullable @NotEmpty String id) {
        this.jti = StringSupport.trimOrNull((String)id);
    }

    @Nullable
    @NotEmpty
    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(@Nullable @NotEmpty String type) {
        this.keyType = type;
    }

    @Nullable
    @NotEmpty
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(@Nullable @NotEmpty String iss) {
        this.issuer = StringSupport.trimOrNull((String)iss);
    }

    @Nullable
    public Instant getExpiration() {
        return this.expiration;
    }

    public void setExpiration(@Nullable Instant exp) {
        this.expiration = exp;
    }

    @JsonGetter(value="exp")
    @NonNegative
    public long getExpirationEpoch() {
        return this.expiration != null ? this.expiration.getEpochSecond() : 0L;
    }

    @JsonSetter(value="exp")
    public void setExpirationEpoch(@NonNegative long exp) {
        this.expiration = Instant.ofEpochSecond(exp);
    }

    @Nullable
    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(@Nullable Instant iat) {
        this.issuedAt = iat;
    }

    @JsonSetter(value="iat")
    public void setIssuedAtEpoch(@NonNegative long iat) {
        this.issuedAt = Instant.ofEpochSecond(iat);
    }

    @JsonGetter(value="iat")
    @NonNegative
    public long getIssuedAtEpoch() {
        return this.issuedAt != null ? this.issuedAt.getEpochSecond() : 0L;
    }

    @Nullable
    @NotEmpty
    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(@Nullable @NotEmpty String prin) {
        this.principal = prin;
    }

    @Nullable
    @NotEmpty
    public String getAuthContext() {
        return this.authContext;
    }

    public void setAuthContext(@Nullable @NotEmpty String acr) {
        this.authContext = StringSupport.trimOrNull((String)acr);
    }

    @Nullable
    public Instant getAuthTime() {
        return this.authTime;
    }

    public void setAuthTime(@Nullable Instant time) {
        this.authTime = time;
    }

    @Nullable
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Map<String, MetadataPolicy> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable @NonnullElements Map<String, MetadataPolicy> data) {
        this.metadata = data != null ? Map.copyOf(data) : null;
    }

    @Nullable
    @NotEmpty
    public String getRelyingPartyId() {
        return this.relyingPartyId;
    }

    public void setRelyingPartyId(@Nullable @NotEmpty String id) {
        this.relyingPartyId = StringSupport.trimOrNull((String)id);
    }

    @Nullable
    @NotEmpty
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(@Nullable @NotEmpty String id) {
        this.clientId = StringSupport.trimOrNull((String)id);
    }

    public boolean isReplacement() {
        Boolean repl = this.replacement;
        return repl == null ? false : repl;
    }

    public void setReplacement(@Nullable Boolean flag) {
        this.replacement = flag;
    }

    public static class Builder {
        @Nullable
        @NotEmpty
        private String jti;
        @Nullable
        @NotEmpty
        private String keyType;
        @Nullable
        @NotEmpty
        private String issuer;
        @Nullable
        private Instant expiration;
        @Nullable
        private Instant issuedAt;
        @Nullable
        @NotEmpty
        private String principal;
        @Nullable
        @NotEmpty
        private String authContext;
        @Nullable
        private Instant authTime;
        @Nullable
        @NonnullElements
        private Map<String, MetadataPolicy> metadata;
        @Nullable
        @NotEmpty
        private String relyingPartyId;
        @Nullable
        @NotEmpty
        private String clientId;
        @Nullable
        private Boolean replacement;

        public Builder(@Nullable @NotEmpty String id) {
            this.jti = id;
            this.keyType = RegistrationClaimsSet.VALUE_TYPE_RT;
        }

        public Builder withType(@Nullable @NotEmpty String type) {
            this.keyType = type;
            return this;
        }

        public Builder withIssuer(@Nullable @NotEmpty String iss) {
            this.issuer = iss;
            return this;
        }

        public Builder withExpiration(@Nullable Instant exp) {
            this.expiration = exp;
            return this;
        }

        public Builder withIssuedAt(@Nullable Instant iat) {
            this.issuedAt = iat;
            return this;
        }

        public Builder withPrincipal(@Nullable @NotEmpty String prncpl) {
            this.principal = prncpl;
            return this;
        }

        public Builder withAcr(@Nullable @NotEmpty String acr) {
            this.authContext = acr;
            return this;
        }

        public Builder withAuthTime(@Nullable Instant time) {
            this.authTime = time;
            return this;
        }

        public Builder withMetadata(@Nullable @NonnullElements Map<String, MetadataPolicy> data) {
            this.metadata = data != null ? Map.copyOf(data) : null;
            return this;
        }

        public Builder withRelyingPartyId(@Nullable @NotEmpty String id) {
            this.relyingPartyId = id;
            return this;
        }

        public Builder withClientId(@Nullable @NotEmpty String id) {
            this.clientId = id;
            return this;
        }

        public Builder withReplacement(@Nullable Boolean flag) {
            this.replacement = flag;
            return this;
        }

        @Nonnull
        public RegistrationClaimsSet build() {
            RegistrationClaimsSet claimsSet = new RegistrationClaimsSet();
            claimsSet.setJti(this.jti);
            claimsSet.setKeyType(this.keyType);
            claimsSet.setIssuer(this.issuer);
            claimsSet.setExpiration(this.expiration);
            claimsSet.setIssuedAt(this.issuedAt);
            claimsSet.setPrincipal(this.principal);
            claimsSet.setAuthContext(this.authContext);
            claimsSet.setAuthTime(this.authTime);
            claimsSet.setMetadata(this.metadata);
            claimsSet.setRelyingPartyId(this.relyingPartyId);
            claimsSet.setClientId(this.clientId);
            claimsSet.setReplacement(this.replacement);
            return claimsSet;
        }
    }
}

