/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.resolver;

import com.google.common.base.Objects;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.ProviderMetadataResolver;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.RefreshableProviderMetadataResolver;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.spring.service.AbstractServiceableComponent;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ServiceableProviderMetadataProvider
extends AbstractServiceableComponent<ProviderMetadataResolver>
implements RefreshableProviderMetadataResolver,
Comparable<ServiceableProviderMetadataProvider> {
    private static int sortKeyValue;
    private final Logger log = LoggerFactory.getLogger(ServiceableProviderMetadataProvider.class);
    @NonnullAfterInit
    private ProviderMetadataResolver resolver;
    @NonnullAfterInit
    private Integer sortKey;

    public void setSortKey(int key) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.sortKey = key;
    }

    public void setEmbeddedResolver(@Nonnull ProviderMetadataResolver theResolver) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.resolver = (ProviderMetadataResolver)Constraint.isNotNull((Object)theResolver, (String)"ProviderMetadataResolver cannot be null");
    }

    @Nonnull
    public ProviderMetadataResolver getEmbeddedResolver() {
        this.ifNotInitializedThrowUninitializedComponentException();
        assert (this.resolver != null);
        return this.resolver;
    }

    @Nonnull
    public Iterable<OIDCProviderMetadata> resolve(ProfileRequestContext profileRequestContext) throws ResolverException {
        return this.resolver.resolve(profileRequestContext);
    }

    @Nullable
    public OIDCProviderMetadata resolveSingle(@Nullable ProfileRequestContext profileRequestContext) throws ResolverException {
        return (OIDCProviderMetadata)this.resolver.resolveSingle(profileRequestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.resolver) {
            throw new ComponentInitializationException("ProviderMetadataResolver cannot be null");
        }
        if (null == this.sortKey) {
            ServiceableProviderMetadataProvider serviceableProviderMetadataProvider = this;
            synchronized (serviceableProviderMetadataProvider) {
                this.setSortKey(++sortKeyValue);
            }
            this.log.info("Top level ProviderMetadata Provider '{}' did not have a sort key; giving it value '{}'", (Object)this.getId(), (Object)this.sortKey);
        }
    }

    public void setId(@Nonnull @NotEmpty String componentId) {
        super.setId(componentId);
    }

    @Nonnull
    public ProviderMetadataResolver getComponent() {
        return this;
    }

    @Override
    public void refresh() throws ResolverException {
        if (this.resolver instanceof RefreshableProviderMetadataResolver) {
            ((RefreshableProviderMetadataResolver)this.resolver).refresh();
        }
    }

    @Override
    public Instant getLastRefresh() {
        if (this.resolver instanceof RefreshableProviderMetadataResolver) {
            return ((RefreshableProviderMetadataResolver)this.resolver).getLastRefresh();
        }
        return null;
    }

    @Override
    public Instant getLastUpdate() {
        if (this.resolver instanceof RefreshableProviderMetadataResolver) {
            return ((RefreshableProviderMetadataResolver)this.resolver).getLastUpdate();
        }
        return null;
    }

    @Override
    public int compareTo(ServiceableProviderMetadataProvider other) {
        this.ifNotInitializedThrowUninitializedComponentException();
        int result = this.sortKey.compareTo(other.sortKey);
        if (result != 0) {
            return result;
        }
        if (this.equals(other)) {
            return 0;
        }
        String id = this.getId();
        assert (id != null);
        return id.compareTo(other.getId());
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof ServiceableProviderMetadataProvider)) {
            return false;
        }
        ServiceableProviderMetadataProvider otherRp = (ServiceableProviderMetadataProvider)other;
        return Objects.equal((Object)otherRp.sortKey, (Object)this.sortKey) && Objects.equal((Object)this.getId(), (Object)otherRp.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sortKey, this.getId()});
    }
}

