/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.logic;

import com.nimbusds.jose.Payload;
import com.nimbusds.jwt.JWT;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import org.opensaml.messaging.context.MessageContext;

public class PayloadFromUserInfoLookupFunction
implements Function<MessageContext, Payload> {
    @Override
    @Nullable
    public Payload apply(@Nullable MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        OIDCAuthenticationResponseContext oidcResponseCtx = (OIDCAuthenticationResponseContext)messageContext.getSubcontext(OIDCAuthenticationResponseContext.class);
        if (oidcResponseCtx == null) {
            return null;
        }
        JWT jwt = oidcResponseCtx.getProcessedToken();
        if (jwt != null) {
            return new Payload(jwt.serialize());
        }
        UserInfo userInfo = oidcResponseCtx.getUserInfo();
        if (userInfo != null) {
            return new Payload((Map)userInfo.toJSONObject());
        }
        return null;
    }
}

