/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.logic;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.AccessTokenContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.slf4j.Logger;

public class JWTClaimsSetFromJWTAccessTokenLookupFunction
implements Function<MessageContext, JWTClaimsSet> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(JWTClaimsSetFromJWTAccessTokenLookupFunction.class);
    @Nonnull
    private Function<MessageContext, AccessTokenContext> accessTokenContextLookupStrategy;

    public JWTClaimsSetFromJWTAccessTokenLookupFunction() {
        Function atcl = new ChildContextLookup(AccessTokenContext.class).compose((Function)new ChildContextLookup(OIDCAuthenticationResponseContext.class));
        assert (atcl != null);
        this.accessTokenContextLookupStrategy = atcl;
    }

    public void setAccessTokenContextCreationStrategy(@Nonnull Function<MessageContext, AccessTokenContext> strategy) {
        this.accessTokenContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AccessTokenContext lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public JWTClaimsSet apply(@Nullable MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        AccessTokenContext tokenCtx = this.accessTokenContextLookupStrategy.apply(messageContext);
        if (tokenCtx == null) {
            return null;
        }
        JWT jwt = tokenCtx.getJWT();
        try {
            if (jwt != null) {
                return jwt.getJWTClaimsSet();
            }
        }
        catch (ParseException e) {
            this.log.error("Could not fetch the claims set from JWT access token", (Throwable)e);
        }
        return null;
    }
}

