#!/usr/bin/env bash
declare LOCATION
declare CLASSPATH
declare VERSION

LOCATION=$(dirname $0)
CLASSPATH=$LOCATION/net.shibboleth.idp.jetty-base/jetty-cli.jar
export CLASSPATH

if [ -e "$LOCATION/jetty-dist/jetty-home-$1.tar.gz" ] ; then
  echo "Error: $LOCATION/jetty-dist/jetty-home-$1.tar.gz already exists"
  exit 1
fi

if [ -e "$LOCATION/jetty-dist/jetty-home-$1" ] ; then
  echo "Error: $LOCATION/jetty-dist/jetty-home-$1 already exists"
  exit 1
fi


VERSION=""
if [ "$#" -ge "1" -a "${1:0:1}" != "-" ] ; then
    VERSION="-v $1"
    shift
elif [ "$#" -eq "0" ] ; then
    while [ -z "$VERSION" ] ; do
        read -p "Jetty version to download: " VERSION
        VERSION="-v $VERSION"
    done
fi

$LOCATION/runclass.sh -Dnet.shibboleth.idp.cli.arguments=net.shibboleth.idp.plugin.jetty.cli.impl.JettyDownloadArugments net.shibboleth.idp.plugin.jetty.cli.impl.JettyDownloadCLI --home "$LOCATION/.." ${VERSION} "$@"
