@echo off

REM
REM We do not want any environment changes we make to escape
REM
setlocal

REM We need a JVM
if not defined JAVA_HOME  (
  echo Error: JAVA_HOME is not defined.
  exit /b
)

set IDP_HOME_WINDOWS=%~dp0..
set IDP_HOME_UNIX=%IDP_HOME_WINDOWS:\=/%
set JETTY_TMP=%IDP_HOME_WINDOWS%\jetty-dist\jetty-tmp
set PRUNSRV=%PROCRUN_HOME%\amd64\prunsrv.exe

if not exist "%JAVA_HOME%\bin\server\jvm.dll" (
  echo Error: %JAVA_HOME%\bin\server\jvm.dll not found
  exit /b
)

if not exist "%JETTY_HOME%\start.jar" (
  echo Error: %JETTY_HOME%\start.jar not found
  exit /b
)

if not exist "%JETTY_BASE%\start.d\idp.ini" (
  echo Error: %JETTY_BASE%\start.d\idp.ini not found
  exit /b
)

if not exist "%PRUNSRV%" (
  echo Error: %PRUNSRV% not found
  exit /b
)

if "%1" EQU "UNINSTALL" (
    @echo on
    "%PRUNSRV%" //DS/Shibd_idp
    exit /b
)

if "%1" EQU "EDIT" (
    @echo on
    start /d "%PROCRUN_HOME%" prunmgr //ES/Shibd_idp
    exit /b
)

if NOT "%1" EQU "INSTALL" (
   echo Usage : config-jetty [EDIT^|INSTALL^|UNINSTALL] [User]
   exit /b
)

if NOT "%2" EQU "" (
   USERNAME=%2
   SET /P PASSWORD="Password for %USERNAME%: "
   SET PR_SERVICEUSER=%USERNAME%
   SET PR_SERVICEPASSWORD=%PASSWORD%
) else (
    SET USERNAME=LocalService
    SET PR_SERVICEUSER=
    SET PR_SERVICEPASSWORD=
)

REM
REM First up create and configure the procrun instance which will run jetty
REM This is described in
REM https://commons.apache.org/proper/commons-daemon/procrun.html
REM And what is set comes from the jetty documentation
REM
REM We use use PR_xxx for parameters to keep things legible and to allow for spaces in paths.
REM But before we do anything we need make sure there is nothing rogue in our environment.
REM
SET PR_DESCRIPTION=
SET PR_DISPLAYNAME=
SET PR_INSTALL=
SET PR_STARTUP=
SET PR_TYPE=
SET PR_DEPENDSON=
SET PR_ENVIRONMENT=
SET PR_USER=
SET PR_PASSWORD=
SET PR_LIBRARYPATH=
SET PR_JAVAHOME=
SET PR_JVM=
SET PR_JVMOPTIONS=
SET PR_JVMOPTIONS9=
SET PR_CLASSPATH=
SET PR_JVMMS=
SET PR_JVMMX=
SET PR_JVMSS=
SET PR_STARTMODE=
SET PR_STARTIMAGE=
SET PR_STARTPATH=
SET PR_STARTCLASS=
SET PR_STARTMETHOD=
SET PR_STARTPARAMS=
SET PR_STOPMODE=
SET PR_STOPIMAGE=
SET PR_STOPPATH=
SET PR_STOPCLASS=
SET PR_STOPMETHOD=
SET PR_STOPPARAMS=
SET PR_STOPTIMEOUT=
SET PR_LOGPATH=
SET PR_LOGPREFIX=
SET PR_LOGLEVEL=
SET PR_LOGJNIMESSAGES=
SET PR_STDOUTPUT=
SET PR_STDERROR=
SET PR_PIDFILE=

REM
REM Now set up the things we do want to set
REM

SET PORTPASS=%random%-%random%-%random%-%random%

SET PR_DISPLAYNAME=Shibboleth IdP Daemon
SET PR_DESCRIPTION=Runs the Jetty Container
SET PR_CLASSPATH=%%JETTY_HOME%%\start.jar
SET PR_JVMOPTIONS=-Didp.home=%IDP_HOME_UNIX%;-Djdk.tls.ephemeralDHKeySize=2048;-Dorg.eclipse.jetty.util.log.class=org.eclipse.jetty.util.log.Slf4jLog;-Djava.io.tmpdir=%JETTY_TMP%;-Dlogback.configurationFile=%JETTY_BASE%\resources\logback.xml;-XX:+UseG1GC
SET PR_JVMMX=2048
SET PR_JVM=auto
SET PR_JAVAHOME=%JAVA_HOME%

SET PR_LOGPATH=%IDP_HOME_WINDOWS%\logs
SET PR_STDOUTPUT=auto
SET PR_STDERROR=auto

SET PR_STARTMODE=JVM
SET PR_STARTCLASS=org.eclipse.jetty.start.Main
SET PR_STARTPARAMS=STOP_PORT=8963;STOP.KEY=%PORTPASS%;jetty.base=%JETTY_BASE%;jetty.logging.dir=%IDP_HOME_WINDOWS%\logs

SET PR_STOPMODE=JVM
SET PR_STOPCLASS=org.eclipse.jetty.start.Main
SET PR_STOPPARAMS=--stop;%PR_STARTPARAMS%

"%PRUNSRV%" //IS/Shibd_idp --Startup=auto

REM
REM With that done poke holes in the firewall using "netsh advfirewall"
REM
netsh advfirewall firewall add rule name="Shibboleth IdP Service" dir=in action=allow program="%PRUNSRV%" enable=yes protocol=tcp

REM
REM Lock down the install
REM
call "%~dp0\setacl.bat" %USERNAME%

REM
REM We also need to create and lock down jetty-tmp
REM
mkdir %JETTY_TMP%
echo Setting FULL ACL on %JETTY_TMP% directory for SYSTEM, Administrators and %USERNAME%
icacls "%JETTY_TMP%" /t /inheritance:r /grant:r "SYSTEM:(OI)(CI)(F)" "Administrators:(OI)(CI)(F)" "%USERNAME%:(OI)(CI)(F)" /q
if ERRORLEVEL 1 (
   echo Error: Could not set ACL
   exit /b
)

echo Setting FULL ACL on %~dp0..jetty-dist\jetty-tmp content for SYSTEM, Administrators and %USERNAME%
icacls "%JETTY_TMP%" /t /inheritance:r /grant:r SYSTEM:F Administrators:F "%USERNAME%:F" /q
if ERRORLEVEL 1 (
  echo Error: Could not set ACL
  exit /b
)


REM
REM start the service
REM

"%PRUNSRV%" //ES/Shibd_idp

REM
REM All done!
REM
exit /b


