#!/usr/bin/env bash

declare JAVACMD
declare LOCATION
declare IDP_HOME
declare JETTY_HOME
declare JETTY_BASE

declare JVM_ARGS
declare JETTY_ARGS
declare JETTY_TMP

LOCATION=$(dirname $0)

if [ -z "$JAVACMD" ] ; then 
  if [ -n "$JAVA_HOME"  ] ; then
    JAVACMD=$JAVA_HOME/bin/java
  else
    JAVACMD=$(which java)
  fi
fi

if [ ! -x "$JAVACMD" ] ; then
  echo "Error: JAVA_HOME is not defined correctly."
  echo "  We cannot execute $JAVACMD"
  exit 1
fi

IDP_HOME=$(realpath ${LOCATION}/..)

if [ ! -e "$JETTY_HOME/start.jar" ] ; then
  echo "Error: JETTY_HOME is not defined correctly."
  echo " $JETTY_HOME/start.jar not found"
  exit 1
fi

if [ ! -d "$JETTY_BASE/start.d" ] ; then
  echo "Error: JETTY_BASE is not defined correctly."
  echo " $JETTY_BASE/start.d not found"
  exit 1
fi

JETTY_TMP=$IDP_HOME/jetty-dist/jetty-tmp
if [ ! -e "$JETTY_TMP" ] ; then
  echo "Creating $JETTY_TMP"
  mkdir "$JETTY_TMP"
fi


JVM_ARGS="-Didp.home=$IDP_HOME -Djdk.tls.ephemeralDHKeySize=2048 -Dorg.eclipse.jetty.util.log.class=org.eclipse.jetty.util.log.Slf4jLog -Djava.io.tmpdir=$JETTY_TMP -XX:+UseG1GC"

JETTY_ARGS="jetty.base=$JETTY_BASE jetty.logging.dir=$IDP_HOME/logs"

$JAVACMD  $JAVA_OPTS '-jar' $JETTY_HOME/start.jar  $JVM_ARGS  $JETTY_ARGS  "$@"

