@echo off
setlocal

REM We need a JVM
if not defined JAVA_HOME  (
  echo Error: JAVA_HOME is not defined.
  exit /b
)

if not defined JAVACMD (
  set JAVACMD="%JAVA_HOME%\bin\java.exe"
)

if not exist %JAVACMD% (
  echo Error: %JAVACMD%  not found
  exit /b
)

set IDP_HOME_WINDOWS=%~dp0..
SET IDP_HOME_UNIX=%IDP_HOME_WINDOWS:\=/%
SET JETTY_TMP=%IDP_HOME_WINDOWS%\jetty-dist\jetty-tmp

if not defined JETTY_HOME (
  echo Error: JETTY_HOME not defined.
  exit /b
)

if not defined JETTY_BASE (
  echo Error: JETTY_BASE not defined.
  exit /b
)

if not exist "%JETTY_HOME%\start.jar" (
  echo Error: JETTY_HOME does not point to a valid Jetty Installation
  exit /b
)

if not exist "%JETTY_TMP%" (
   mkdir %JETTY_TMP%
)

if not exist "%JETTY_BASE%\start.d" (
  echo Error: JETTY_BASE does not point to a Jetty Base
  exit /b
)

set JVM_ARGS=-Didp.home="%IDP_HOME_UNIX%" -Djdk.tls.ephemeralDHKeySize=2048 -Dorg.eclipse.jetty.util.log.class=org.eclipse.jetty.util.log.Slf4jLog -Djava.io.tmpdir="%JETTY_TMP%" -XX:+UseG1GC


SET JETTY_ARGS=jetty.base="%JETTY_BASE%" jetty.logging.dir="%IDP_HOME_WINDOWS%\logs"

%JAVACMD%  %JAVA_OPTS% -jar "%JETTY_HOME%/start.jar" %JVM_ARGS% %JETTY_ARGS% %*
