/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.upokecenter.cbor.CBORObject;
import com.yubico.internal.util.CertificateParser;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.internal.util.OptionalUtil;
import com.yubico.webauthn.AndroidSafetynetAttestationStatementVerifier;
import com.yubico.webauthn.AppleAttestationStatementVerifier;
import com.yubico.webauthn.AttestationStatementVerifier;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.Crypto;
import com.yubico.webauthn.FidoU2fAttestationStatementVerifier;
import com.yubico.webauthn.NoneAttestationStatementVerifier;
import com.yubico.webauthn.OriginMatcher;
import com.yubico.webauthn.PackedAttestationStatementVerifier;
import com.yubico.webauthn.RegistrationResult;
import com.yubico.webauthn.TokenBindingValidator;
import com.yubico.webauthn.TpmAttestationStatementVerifier;
import com.yubico.webauthn.WebAuthnCodecs;
import com.yubico.webauthn.X5cAttestationStatementVerifier;
import com.yubico.webauthn.attestation.AttestationTrustSource;
import com.yubico.webauthn.data.AttestationObject;
import com.yubico.webauthn.data.AttestationType;
import com.yubico.webauthn.data.AuthenticatorAttestationResponse;
import com.yubico.webauthn.data.AuthenticatorSelectionCriteria;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientRegistrationExtensionOutputs;
import com.yubico.webauthn.data.CollectedClientData;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialCreationOptions;
import com.yubico.webauthn.data.PublicKeyCredentialParameters;
import com.yubico.webauthn.data.UserVerificationRequirement;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXReason;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.sql.Date;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FinishRegistrationSteps {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FinishRegistrationSteps.class);
    private static final String CLIENT_DATA_TYPE = "webauthn.create";
    private static final ByteArray ZERO_AAGUID = new ByteArray(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private final PublicKeyCredentialCreationOptions request;
    private final PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> response;
    private final Optional<ByteArray> callerTokenBindingId;
    private final Set<String> origins;
    private final String rpId;
    private final boolean allowUntrustedAttestation;
    private final Optional<AttestationTrustSource> attestationTrustSource;
    private final CredentialRepository credentialRepository;
    private final Clock clock;
    private final boolean allowOriginPort;
    private final boolean allowOriginSubdomain;
    private final boolean allowUnrequestedExtensions;

    public Step6 begin() {
        return new Step6();
    }

    public RegistrationResult run() {
        return this.begin().run();
    }

    @Generated
    private static boolean $default$allowOriginPort() {
        return false;
    }

    @Generated
    private static boolean $default$allowOriginSubdomain() {
        return false;
    }

    @Generated
    private static boolean $default$allowUnrequestedExtensions() {
        return false;
    }

    @Generated
    FinishRegistrationSteps(PublicKeyCredentialCreationOptions request, PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> response, Optional<ByteArray> callerTokenBindingId, Set<String> origins, String rpId, boolean allowUntrustedAttestation, Optional<AttestationTrustSource> attestationTrustSource, CredentialRepository credentialRepository, Clock clock, boolean allowOriginPort, boolean allowOriginSubdomain, boolean allowUnrequestedExtensions) {
        this.request = request;
        this.response = response;
        this.callerTokenBindingId = callerTokenBindingId;
        this.origins = origins;
        this.rpId = rpId;
        this.allowUntrustedAttestation = allowUntrustedAttestation;
        this.attestationTrustSource = attestationTrustSource;
        this.credentialRepository = credentialRepository;
        this.clock = clock;
        this.allowOriginPort = allowOriginPort;
        this.allowOriginSubdomain = allowOriginSubdomain;
        this.allowUnrequestedExtensions = allowUnrequestedExtensions;
    }

    @Generated
    public static FinishRegistrationStepsBuilder builder() {
        return new FinishRegistrationStepsBuilder();
    }

    final class Step6
    implements Step<Step7> {
        @Override
        public void validate() {
            ExceptionUtil.assertTrue((this.clientData() != null ? 1 : 0) != 0, (String)"Client data must not be null.", (Object[])new Object[0]);
        }

        @Override
        public Step7 nextStep() {
            return new Step7(this.clientData());
        }

        public CollectedClientData clientData() {
            return ((AuthenticatorAttestationResponse)FinishRegistrationSteps.this.response.getResponse()).getClientData();
        }

        @Generated
        public Step6() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Step6;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step6()";
        }
    }

    @Generated
    public static class FinishRegistrationStepsBuilder {
        @Generated
        private PublicKeyCredentialCreationOptions request;
        @Generated
        private PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> response;
        @Generated
        private Optional<ByteArray> callerTokenBindingId;
        @Generated
        private Set<String> origins;
        @Generated
        private String rpId;
        @Generated
        private boolean allowUntrustedAttestation;
        @Generated
        private Optional<AttestationTrustSource> attestationTrustSource;
        @Generated
        private CredentialRepository credentialRepository;
        @Generated
        private Clock clock;
        @Generated
        private boolean allowOriginPort$set;
        @Generated
        private boolean allowOriginPort$value;
        @Generated
        private boolean allowOriginSubdomain$set;
        @Generated
        private boolean allowOriginSubdomain$value;
        @Generated
        private boolean allowUnrequestedExtensions$set;
        @Generated
        private boolean allowUnrequestedExtensions$value;

        @Generated
        FinishRegistrationStepsBuilder() {
        }

        @Generated
        public FinishRegistrationStepsBuilder request(PublicKeyCredentialCreationOptions request) {
            this.request = request;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder response(PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> response) {
            this.response = response;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder callerTokenBindingId(Optional<ByteArray> callerTokenBindingId) {
            this.callerTokenBindingId = callerTokenBindingId;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder origins(Set<String> origins) {
            this.origins = origins;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder rpId(String rpId) {
            this.rpId = rpId;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder allowUntrustedAttestation(boolean allowUntrustedAttestation) {
            this.allowUntrustedAttestation = allowUntrustedAttestation;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder attestationTrustSource(Optional<AttestationTrustSource> attestationTrustSource) {
            this.attestationTrustSource = attestationTrustSource;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder credentialRepository(CredentialRepository credentialRepository) {
            this.credentialRepository = credentialRepository;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder allowOriginPort(boolean allowOriginPort) {
            this.allowOriginPort$value = allowOriginPort;
            this.allowOriginPort$set = true;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder allowOriginSubdomain(boolean allowOriginSubdomain) {
            this.allowOriginSubdomain$value = allowOriginSubdomain;
            this.allowOriginSubdomain$set = true;
            return this;
        }

        @Generated
        public FinishRegistrationStepsBuilder allowUnrequestedExtensions(boolean allowUnrequestedExtensions) {
            this.allowUnrequestedExtensions$value = allowUnrequestedExtensions;
            this.allowUnrequestedExtensions$set = true;
            return this;
        }

        @Generated
        public FinishRegistrationSteps build() {
            boolean allowOriginPort$value = this.allowOriginPort$value;
            if (!this.allowOriginPort$set) {
                allowOriginPort$value = FinishRegistrationSteps.$default$allowOriginPort();
            }
            boolean allowOriginSubdomain$value = this.allowOriginSubdomain$value;
            if (!this.allowOriginSubdomain$set) {
                allowOriginSubdomain$value = FinishRegistrationSteps.$default$allowOriginSubdomain();
            }
            boolean allowUnrequestedExtensions$value = this.allowUnrequestedExtensions$value;
            if (!this.allowUnrequestedExtensions$set) {
                allowUnrequestedExtensions$value = FinishRegistrationSteps.$default$allowUnrequestedExtensions();
            }
            return new FinishRegistrationSteps(this.request, this.response, this.callerTokenBindingId, this.origins, this.rpId, this.allowUntrustedAttestation, this.attestationTrustSource, this.credentialRepository, this.clock, allowOriginPort$value, allowOriginSubdomain$value, allowUnrequestedExtensions$value);
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.FinishRegistrationStepsBuilder(request=" + this.request + ", response=" + this.response + ", callerTokenBindingId=" + this.callerTokenBindingId + ", origins=" + this.origins + ", rpId=" + this.rpId + ", allowUntrustedAttestation=" + this.allowUntrustedAttestation + ", attestationTrustSource=" + this.attestationTrustSource + ", credentialRepository=" + this.credentialRepository + ", clock=" + this.clock + ", allowOriginPort$value=" + this.allowOriginPort$value + ", allowOriginSubdomain$value=" + this.allowOriginSubdomain$value + ", allowUnrequestedExtensions$value=" + this.allowUnrequestedExtensions$value + ")";
        }
    }

    final class Finished
    implements Step<Finished> {
        private final AttestationType attestationType;
        private final boolean attestationTrusted;
        private final Optional<List<X509Certificate>> attestationTrustPath;

        @Override
        public void validate() {
        }

        @Override
        public Finished nextStep() {
            return this;
        }

        @Override
        public Optional<RegistrationResult> result() {
            return Optional.of(new RegistrationResult(FinishRegistrationSteps.this.response, this.attestationTrusted, this.attestationType, this.attestationTrustPath));
        }

        @Generated
        public Finished(AttestationType attestationType, boolean attestationTrusted, Optional<List<X509Certificate>> attestationTrustPath) {
            this.attestationType = attestationType;
            this.attestationTrusted = attestationTrusted;
            this.attestationTrustPath = attestationTrustPath;
        }

        @Generated
        public AttestationType getAttestationType() {
            return this.attestationType;
        }

        @Generated
        public boolean isAttestationTrusted() {
            return this.attestationTrusted;
        }

        @Generated
        public Optional<List<X509Certificate>> getAttestationTrustPath() {
            return this.attestationTrustPath;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Finished)) {
                return false;
            }
            Finished other = (Finished)o;
            if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
                return false;
            }
            AttestationType this$attestationType = this.getAttestationType();
            AttestationType other$attestationType = other.getAttestationType();
            if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
                return false;
            }
            Optional<List<X509Certificate>> this$attestationTrustPath = this.getAttestationTrustPath();
            Optional<List<X509Certificate>> other$attestationTrustPath = other.getAttestationTrustPath();
            return !(this$attestationTrustPath == null ? other$attestationTrustPath != null : !((Object)this$attestationTrustPath).equals(other$attestationTrustPath));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
            AttestationType $attestationType = this.getAttestationType();
            result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
            Optional<List<X509Certificate>> $attestationTrustPath = this.getAttestationTrustPath();
            result = result * 59 + ($attestationTrustPath == null ? 43 : ((Object)$attestationTrustPath).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Finished(attestationType=" + (Object)((Object)this.getAttestationType()) + ", attestationTrusted=" + this.isAttestationTrusted() + ", attestationTrustPath=" + this.getAttestationTrustPath() + ")";
        }
    }

    final class Step22
    implements Step<Finished> {
        private final AttestationType attestationType;
        private final boolean attestationTrusted;
        private final Optional<List<X509Certificate>> attestationTrustPath;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((boolean)FinishRegistrationSteps.this.credentialRepository.lookupAll(FinishRegistrationSteps.this.response.getId()).isEmpty(), (String)"Credential ID is already registered: %s", (Object[])new Object[]{FinishRegistrationSteps.this.response.getId()});
        }

        @Override
        public Finished nextStep() {
            return new Finished(this.attestationType, this.attestationTrusted, this.attestationTrustPath);
        }

        @Generated
        public Step22(AttestationType attestationType, boolean attestationTrusted, Optional<List<X509Certificate>> attestationTrustPath) {
            this.attestationType = attestationType;
            this.attestationTrusted = attestationTrusted;
            this.attestationTrustPath = attestationTrustPath;
        }

        @Generated
        public AttestationType getAttestationType() {
            return this.attestationType;
        }

        @Generated
        public boolean isAttestationTrusted() {
            return this.attestationTrusted;
        }

        @Generated
        public Optional<List<X509Certificate>> getAttestationTrustPath() {
            return this.attestationTrustPath;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step22)) {
                return false;
            }
            Step22 other = (Step22)o;
            if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
                return false;
            }
            AttestationType this$attestationType = this.getAttestationType();
            AttestationType other$attestationType = other.getAttestationType();
            if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
                return false;
            }
            Optional<List<X509Certificate>> this$attestationTrustPath = this.getAttestationTrustPath();
            Optional<List<X509Certificate>> other$attestationTrustPath = other.getAttestationTrustPath();
            return !(this$attestationTrustPath == null ? other$attestationTrustPath != null : !((Object)this$attestationTrustPath).equals(other$attestationTrustPath));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
            AttestationType $attestationType = this.getAttestationType();
            result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
            Optional<List<X509Certificate>> $attestationTrustPath = this.getAttestationTrustPath();
            result = result * 59 + ($attestationTrustPath == null ? 43 : ((Object)$attestationTrustPath).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step22(attestationType=" + (Object)((Object)this.getAttestationType()) + ", attestationTrusted=" + this.isAttestationTrusted() + ", attestationTrustPath=" + this.getAttestationTrustPath() + ")";
        }
    }

    final class Step21
    implements Step<Step22> {
        private final AttestationObject attestation;
        private final AttestationType attestationType;
        private final Optional<List<X509Certificate>> attestationTrustPath;
        private final Optional<AttestationTrustSource.TrustRootsResult> trustRoots;
        private final boolean attestationTrusted;

        public Step21(AttestationObject attestation, AttestationType attestationType, Optional<List<X509Certificate>> attestationTrustPath, Optional<AttestationTrustSource.TrustRootsResult> trustRoots) {
            this.attestation = attestation;
            this.attestationType = attestationType;
            this.attestationTrustPath = attestationTrustPath;
            this.trustRoots = trustRoots;
            this.attestationTrusted = this.attestationTrusted();
        }

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((FinishRegistrationSteps.this.allowUntrustedAttestation || this.attestationTrusted ? 1 : 0) != 0, (String)"Failed to derive trust for attestation key.", (Object[])new Object[0]);
        }

        @Override
        public Step22 nextStep() {
            return new Step22(this.attestationType, this.attestationTrusted, this.attestationTrustPath);
        }

        public boolean attestationTrusted() {
            if (this.attestationTrustPath.isPresent() && FinishRegistrationSteps.this.attestationTrustSource.isPresent()) {
                try {
                    if (!this.trustRoots.isPresent() || this.trustRoots.get().getTrustRoots().isEmpty()) {
                        return false;
                    }
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                    CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
                    CertPath certPath = certFactory.generateCertPath(this.attestationTrustPath.get());
                    PKIXParameters pathParams = new PKIXParameters(this.trustRoots.get().getTrustRoots().stream().map(rootCert -> new TrustAnchor((X509Certificate)rootCert, null)).collect(Collectors.toSet()));
                    pathParams.setDate(Date.from(FinishRegistrationSteps.this.clock.instant()));
                    pathParams.setRevocationEnabled(this.trustRoots.get().isEnableRevocationChecking());
                    pathParams.setPolicyQualifiersRejected(!this.trustRoots.get().getPolicyTreeValidator().isPresent());
                    this.trustRoots.get().getCertStore().ifPresent(pathParams::addCertStore);
                    PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)cpv.validate(certPath, pathParams);
                    return this.trustRoots.get().getPolicyTreeValidator().map(policyNodePredicate -> {
                        if (policyNodePredicate.test(result.getPolicyTree())) {
                            return true;
                        }
                        log.info("Failed to derive trust in attestation statement: Certificate path policy tree does not satisfy policy tree validator. Attestation object: {}", (Object)((AuthenticatorAttestationResponse)FinishRegistrationSteps.this.response.getResponse()).getAttestationObject());
                        return false;
                    }).orElse(true);
                }
                catch (CertPathValidatorException e) {
                    log.info("Failed to derive trust in attestation statement: {} at cert index {}: {}. Attestation object: {}", new Object[]{e.getReason(), e.getIndex(), e.getMessage(), ((AuthenticatorAttestationResponse)FinishRegistrationSteps.this.response.getResponse()).getAttestationObject()});
                    if (PKIXReason.INVALID_POLICY.equals(e.getReason())) {
                        log.info("You may need to set the policyTreeValidator property on the {} returned by your {}.", (Object)AttestationTrustSource.TrustRootsResult.class.getSimpleName(), (Object)AttestationTrustSource.class.getSimpleName());
                    }
                    return false;
                }
                catch (CertificateException e) {
                    log.warn("Failed to build attestation certificate path. Attestation object: {}", (Object)((AuthenticatorAttestationResponse)FinishRegistrationSteps.this.response.getResponse()).getAttestationObject(), (Object)e);
                    return false;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Failed to check attestation trust path. A JCA provider is likely missing in the runtime environment.", e);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new RuntimeException("Failed to initialize attestation trust path validator. This is likely a bug, please file a bug report.", e);
                }
            }
            return false;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Generated
        public AttestationType getAttestationType() {
            return this.attestationType;
        }

        @Generated
        public Optional<List<X509Certificate>> getAttestationTrustPath() {
            return this.attestationTrustPath;
        }

        @Generated
        public Optional<AttestationTrustSource.TrustRootsResult> getTrustRoots() {
            return this.trustRoots;
        }

        @Generated
        public boolean isAttestationTrusted() {
            return this.attestationTrusted;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step21)) {
                return false;
            }
            Step21 other = (Step21)o;
            if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
                return false;
            }
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            if (this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation)) {
                return false;
            }
            AttestationType this$attestationType = this.getAttestationType();
            AttestationType other$attestationType = other.getAttestationType();
            if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
                return false;
            }
            Optional<List<X509Certificate>> this$attestationTrustPath = this.getAttestationTrustPath();
            Optional<List<X509Certificate>> other$attestationTrustPath = other.getAttestationTrustPath();
            if (this$attestationTrustPath == null ? other$attestationTrustPath != null : !((Object)this$attestationTrustPath).equals(other$attestationTrustPath)) {
                return false;
            }
            Optional<AttestationTrustSource.TrustRootsResult> this$trustRoots = this.getTrustRoots();
            Optional<AttestationTrustSource.TrustRootsResult> other$trustRoots = other.getTrustRoots();
            return !(this$trustRoots == null ? other$trustRoots != null : !((Object)this$trustRoots).equals(other$trustRoots));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            AttestationType $attestationType = this.getAttestationType();
            result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
            Optional<List<X509Certificate>> $attestationTrustPath = this.getAttestationTrustPath();
            result = result * 59 + ($attestationTrustPath == null ? 43 : ((Object)$attestationTrustPath).hashCode());
            Optional<AttestationTrustSource.TrustRootsResult> $trustRoots = this.getTrustRoots();
            result = result * 59 + ($trustRoots == null ? 43 : ((Object)$trustRoots).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step21(attestation=" + this.getAttestation() + ", attestationType=" + (Object)((Object)this.getAttestationType()) + ", attestationTrustPath=" + this.getAttestationTrustPath() + ", trustRoots=" + this.getTrustRoots() + ", attestationTrusted=" + this.isAttestationTrusted() + ")";
        }
    }

    final class Step20
    implements Step<Step21> {
        private final AttestationObject attestation;
        private final AttestationType attestationType;
        private final Optional<List<X509Certificate>> attestationTrustPath;
        private final Optional<AttestationTrustSource.TrustRootsResult> trustRoots;

        public Step20(AttestationObject attestation, AttestationType attestationType, Optional<List<X509Certificate>> attestationTrustPath) {
            this.attestation = attestation;
            this.attestationType = attestationType;
            this.attestationTrustPath = attestationTrustPath;
            this.trustRoots = this.findTrustRoots();
        }

        @Override
        public void validate() {
        }

        @Override
        public Step21 nextStep() {
            return new Step21(this.attestation, this.attestationType, this.attestationTrustPath, this.trustRoots);
        }

        private Optional<AttestationTrustSource.TrustRootsResult> findTrustRoots() {
            return FinishRegistrationSteps.this.attestationTrustSource.flatMap(attestationTrustSource -> this.attestationTrustPath.map(atp -> attestationTrustSource.findTrustRoots((List<X509Certificate>)atp, OptionalUtil.orElseOptional(Optional.of(this.attestation.getAuthenticatorData().getAttestedCredentialData().get().getAaguid()).filter(aaguid -> !aaguid.equals(ZERO_AAGUID)), () -> {
                if (!atp.isEmpty()) {
                    return CertificateParser.parseFidoAaguidExtension((X509Certificate)((X509Certificate)atp.get(0))).map(ByteArray::new);
                }
                return Optional.empty();
            }))));
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Generated
        public AttestationType getAttestationType() {
            return this.attestationType;
        }

        @Generated
        public Optional<List<X509Certificate>> getAttestationTrustPath() {
            return this.attestationTrustPath;
        }

        @Generated
        public Optional<AttestationTrustSource.TrustRootsResult> getTrustRoots() {
            return this.trustRoots;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step20)) {
                return false;
            }
            Step20 other = (Step20)o;
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            if (this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation)) {
                return false;
            }
            AttestationType this$attestationType = this.getAttestationType();
            AttestationType other$attestationType = other.getAttestationType();
            if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
                return false;
            }
            Optional<List<X509Certificate>> this$attestationTrustPath = this.getAttestationTrustPath();
            Optional<List<X509Certificate>> other$attestationTrustPath = other.getAttestationTrustPath();
            if (this$attestationTrustPath == null ? other$attestationTrustPath != null : !((Object)this$attestationTrustPath).equals(other$attestationTrustPath)) {
                return false;
            }
            Optional<AttestationTrustSource.TrustRootsResult> this$trustRoots = this.getTrustRoots();
            Optional<AttestationTrustSource.TrustRootsResult> other$trustRoots = other.getTrustRoots();
            return !(this$trustRoots == null ? other$trustRoots != null : !((Object)this$trustRoots).equals(other$trustRoots));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            AttestationType $attestationType = this.getAttestationType();
            result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
            Optional<List<X509Certificate>> $attestationTrustPath = this.getAttestationTrustPath();
            result = result * 59 + ($attestationTrustPath == null ? 43 : ((Object)$attestationTrustPath).hashCode());
            Optional<AttestationTrustSource.TrustRootsResult> $trustRoots = this.getTrustRoots();
            result = result * 59 + ($trustRoots == null ? 43 : ((Object)$trustRoots).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step20(attestation=" + this.getAttestation() + ", attestationType=" + (Object)((Object)this.getAttestationType()) + ", attestationTrustPath=" + this.getAttestationTrustPath() + ", trustRoots=" + this.getTrustRoots() + ")";
        }
    }

    final class Step19
    implements Step<Step20> {
        private final ByteArray clientDataJsonHash;
        private final AttestationObject attestation;
        private final Optional<AttestationStatementVerifier> attestationStatementVerifier;

        @Override
        public void validate() {
            this.attestationStatementVerifier.ifPresent(verifier -> ExceptionUtil.assertTrue((boolean)verifier.verifyAttestationSignature(this.attestation, this.clientDataJsonHash), (String)"Invalid attestation signature.", (Object[])new Object[0]));
            ExceptionUtil.assertTrue((this.attestationType() != null ? 1 : 0) != 0, (String)"Failed to determine attestation type", (Object[])new Object[0]);
        }

        @Override
        public Step20 nextStep() {
            return new Step20(this.attestation, this.attestationType(), this.attestationTrustPath());
        }

        public AttestationType attestationType() {
            try {
                if (this.attestationStatementVerifier.isPresent()) {
                    return this.attestationStatementVerifier.get().getAttestationType(this.attestation);
                }
                switch (this.attestation.getFormat()) {
                    case "android-key": {
                        return AttestationType.BASIC;
                    }
                }
                return AttestationType.UNKNOWN;
            }
            catch (IOException | CertificateException e) {
                throw new IllegalArgumentException("Failed to resolve attestation type.", e);
            }
        }

        public Optional<List<X509Certificate>> attestationTrustPath() {
            if (this.attestationStatementVerifier.isPresent()) {
                AttestationStatementVerifier verifier = this.attestationStatementVerifier.get();
                if (verifier instanceof X5cAttestationStatementVerifier) {
                    try {
                        return ((X5cAttestationStatementVerifier)((Object)verifier)).getAttestationTrustPath(this.attestation);
                    }
                    catch (CertificateException e) {
                        throw new IllegalArgumentException("Failed to resolve attestation trust path.", e);
                    }
                }
                return Optional.empty();
            }
            return Optional.empty();
        }

        @Generated
        public Step19(ByteArray clientDataJsonHash, AttestationObject attestation, Optional<AttestationStatementVerifier> attestationStatementVerifier) {
            this.clientDataJsonHash = clientDataJsonHash;
            this.attestation = attestation;
            this.attestationStatementVerifier = attestationStatementVerifier;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Generated
        public Optional<AttestationStatementVerifier> getAttestationStatementVerifier() {
            return this.attestationStatementVerifier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step19)) {
                return false;
            }
            Step19 other = (Step19)o;
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            if (this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash)) {
                return false;
            }
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            if (this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation)) {
                return false;
            }
            Optional<AttestationStatementVerifier> this$attestationStatementVerifier = this.getAttestationStatementVerifier();
            Optional<AttestationStatementVerifier> other$attestationStatementVerifier = other.getAttestationStatementVerifier();
            return !(this$attestationStatementVerifier == null ? other$attestationStatementVerifier != null : !((Object)this$attestationStatementVerifier).equals(other$attestationStatementVerifier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            Optional<AttestationStatementVerifier> $attestationStatementVerifier = this.getAttestationStatementVerifier();
            result = result * 59 + ($attestationStatementVerifier == null ? 43 : ((Object)$attestationStatementVerifier).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step19(clientDataJsonHash=" + this.getClientDataJsonHash() + ", attestation=" + this.getAttestation() + ", attestationStatementVerifier=" + this.getAttestationStatementVerifier() + ")";
        }
    }

    final class Step18
    implements Step<Step19> {
        private final ByteArray clientDataJsonHash;
        private final AttestationObject attestation;

        @Override
        public void validate() {
        }

        @Override
        public Step19 nextStep() {
            return new Step19(this.clientDataJsonHash, this.attestation, this.attestationStatementVerifier());
        }

        public String format() {
            return this.attestation.getFormat();
        }

        public Optional<AttestationStatementVerifier> attestationStatementVerifier() {
            switch (this.format()) {
                case "fido-u2f": {
                    return Optional.of(new FidoU2fAttestationStatementVerifier());
                }
                case "none": {
                    return Optional.of(new NoneAttestationStatementVerifier());
                }
                case "packed": {
                    return Optional.of(new PackedAttestationStatementVerifier());
                }
                case "android-safetynet": {
                    return Optional.of(new AndroidSafetynetAttestationStatementVerifier());
                }
                case "apple": {
                    return Optional.of(new AppleAttestationStatementVerifier());
                }
                case "tpm": {
                    return Optional.of(new TpmAttestationStatementVerifier());
                }
            }
            return Optional.empty();
        }

        @Generated
        public Step18(ByteArray clientDataJsonHash, AttestationObject attestation) {
            this.clientDataJsonHash = clientDataJsonHash;
            this.attestation = attestation;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step18)) {
                return false;
            }
            Step18 other = (Step18)o;
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            if (this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash)) {
                return false;
            }
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            return !(this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step18(clientDataJsonHash=" + this.getClientDataJsonHash() + ", attestation=" + this.getAttestation() + ")";
        }
    }

    final class Step16
    implements Step<Step18> {
        private final ByteArray clientDataJsonHash;
        private final AttestationObject attestation;

        @Override
        public void validate() {
            ByteArray publicKeyCose = ((AuthenticatorAttestationResponse)FinishRegistrationSteps.this.response.getResponse()).getAttestation().getAuthenticatorData().getAttestedCredentialData().get().getCredentialPublicKey();
            CBORObject publicKeyCbor = CBORObject.DecodeFromBytes((byte[])publicKeyCose.getBytes());
            int alg = publicKeyCbor.get(CBORObject.FromObject((int)3)).AsInt32();
            ExceptionUtil.assertTrue((boolean)FinishRegistrationSteps.this.request.getPubKeyCredParams().stream().anyMatch(pkcparam -> pkcparam.getAlg().getId() == (long)alg), (String)"Unrequested credential key algorithm: got %d, expected one of: %s", (Object[])new Object[]{alg, FinishRegistrationSteps.this.request.getPubKeyCredParams().stream().map(PublicKeyCredentialParameters::getAlg).collect(Collectors.toList())});
            try {
                WebAuthnCodecs.importCosePublicKey(publicKeyCose);
            }
            catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw ExceptionUtil.wrapAndLog((Logger)log, (String)"Failed to parse credential public key", (Throwable)e);
            }
        }

        @Override
        public Step18 nextStep() {
            return new Step18(this.clientDataJsonHash, this.attestation);
        }

        @Generated
        public Step16(ByteArray clientDataJsonHash, AttestationObject attestation) {
            this.clientDataJsonHash = clientDataJsonHash;
            this.attestation = attestation;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step16)) {
                return false;
            }
            Step16 other = (Step16)o;
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            if (this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash)) {
                return false;
            }
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            return !(this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step16(clientDataJsonHash=" + this.getClientDataJsonHash() + ", attestation=" + this.getAttestation() + ")";
        }
    }

    final class Step15
    implements Step<Step16> {
        private final ByteArray clientDataJsonHash;
        private final AttestationObject attestation;

        @Override
        public void validate() {
            if (FinishRegistrationSteps.this.request.getAuthenticatorSelection().flatMap(AuthenticatorSelectionCriteria::getUserVerification).orElse(UserVerificationRequirement.PREFERRED) == UserVerificationRequirement.REQUIRED) {
                ExceptionUtil.assertTrue((boolean)((AuthenticatorAttestationResponse)((FinishRegistrationSteps)FinishRegistrationSteps.this).response.getResponse()).getParsedAuthenticatorData().getFlags().UV, (String)"User Verification is required.", (Object[])new Object[0]);
            }
        }

        @Override
        public Step16 nextStep() {
            return new Step16(this.clientDataJsonHash, this.attestation);
        }

        @Generated
        public Step15(ByteArray clientDataJsonHash, AttestationObject attestation) {
            this.clientDataJsonHash = clientDataJsonHash;
            this.attestation = attestation;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step15)) {
                return false;
            }
            Step15 other = (Step15)o;
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            if (this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash)) {
                return false;
            }
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            return !(this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step15(clientDataJsonHash=" + this.getClientDataJsonHash() + ", attestation=" + this.getAttestation() + ")";
        }
    }

    final class Step14
    implements Step<Step15> {
        private final ByteArray clientDataJsonHash;
        private final AttestationObject attestation;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((boolean)((AuthenticatorAttestationResponse)((FinishRegistrationSteps)FinishRegistrationSteps.this).response.getResponse()).getParsedAuthenticatorData().getFlags().UP, (String)"User Presence is required.", (Object[])new Object[0]);
        }

        @Override
        public Step15 nextStep() {
            return new Step15(this.clientDataJsonHash, this.attestation);
        }

        @Generated
        public Step14(ByteArray clientDataJsonHash, AttestationObject attestation) {
            this.clientDataJsonHash = clientDataJsonHash;
            this.attestation = attestation;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step14)) {
                return false;
            }
            Step14 other = (Step14)o;
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            if (this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash)) {
                return false;
            }
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            return !(this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step14(clientDataJsonHash=" + this.getClientDataJsonHash() + ", attestation=" + this.getAttestation() + ")";
        }
    }

    final class Step13
    implements Step<Step14> {
        private final ByteArray clientDataJsonHash;
        private final AttestationObject attestation;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((boolean)Crypto.sha256(FinishRegistrationSteps.this.rpId).equals(((AuthenticatorAttestationResponse)FinishRegistrationSteps.this.response.getResponse()).getAttestation().getAuthenticatorData().getRpIdHash()), (String)"Wrong RP ID hash.", (Object[])new Object[0]);
        }

        @Override
        public Step14 nextStep() {
            return new Step14(this.clientDataJsonHash, this.attestation);
        }

        @Generated
        public Step13(ByteArray clientDataJsonHash, AttestationObject attestation) {
            this.clientDataJsonHash = clientDataJsonHash;
            this.attestation = attestation;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public AttestationObject getAttestation() {
            return this.attestation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step13)) {
                return false;
            }
            Step13 other = (Step13)o;
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            if (this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash)) {
                return false;
            }
            AttestationObject this$attestation = this.getAttestation();
            AttestationObject other$attestation = other.getAttestation();
            return !(this$attestation == null ? other$attestation != null : !((Object)this$attestation).equals(other$attestation));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            AttestationObject $attestation = this.getAttestation();
            result = result * 59 + ($attestation == null ? 43 : ((Object)$attestation).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step13(clientDataJsonHash=" + this.getClientDataJsonHash() + ", attestation=" + this.getAttestation() + ")";
        }
    }

    final class Step12
    implements Step<Step13> {
        private final ByteArray clientDataJsonHash;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((this.attestation() != null ? 1 : 0) != 0, (String)"Malformed attestation object.", (Object[])new Object[0]);
        }

        @Override
        public Step13 nextStep() {
            return new Step13(this.clientDataJsonHash, this.attestation());
        }

        public AttestationObject attestation() {
            return ((AuthenticatorAttestationResponse)FinishRegistrationSteps.this.response.getResponse()).getAttestation();
        }

        @Generated
        public Step12(ByteArray clientDataJsonHash) {
            this.clientDataJsonHash = clientDataJsonHash;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step12)) {
                return false;
            }
            Step12 other = (Step12)o;
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            return !(this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step12(clientDataJsonHash=" + this.getClientDataJsonHash() + ")";
        }
    }

    final class Step11
    implements Step<Step12> {
        @Override
        public void validate() {
            ExceptionUtil.assertTrue((this.clientDataJsonHash().size() == 32 ? 1 : 0) != 0, (String)"Failed to compute hash of client data", (Object[])new Object[0]);
        }

        @Override
        public Step12 nextStep() {
            return new Step12(this.clientDataJsonHash());
        }

        public ByteArray clientDataJsonHash() {
            return Crypto.sha256(((AuthenticatorAttestationResponse)FinishRegistrationSteps.this.response.getResponse()).getClientDataJSON());
        }

        @Generated
        public Step11() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Step11;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step11()";
        }
    }

    final class Step10
    implements Step<Step11> {
        private final CollectedClientData clientData;

        @Override
        public void validate() {
            TokenBindingValidator.validate(this.clientData.getTokenBinding(), FinishRegistrationSteps.this.callerTokenBindingId);
        }

        @Override
        public Step11 nextStep() {
            return new Step11();
        }

        @Generated
        public Step10(CollectedClientData clientData) {
            this.clientData = clientData;
        }

        @Generated
        public CollectedClientData getClientData() {
            return this.clientData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step10)) {
                return false;
            }
            Step10 other = (Step10)o;
            CollectedClientData this$clientData = this.getClientData();
            CollectedClientData other$clientData = other.getClientData();
            return !(this$clientData == null ? other$clientData != null : !((Object)this$clientData).equals(other$clientData));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CollectedClientData $clientData = this.getClientData();
            result = result * 59 + ($clientData == null ? 43 : ((Object)$clientData).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step10(clientData=" + this.getClientData() + ")";
        }
    }

    final class Step9
    implements Step<Step10> {
        private final CollectedClientData clientData;

        @Override
        public void validate() {
            String responseOrigin = this.clientData.getOrigin();
            ExceptionUtil.assertTrue((boolean)OriginMatcher.isAllowed(responseOrigin, FinishRegistrationSteps.this.origins, FinishRegistrationSteps.this.allowOriginPort, FinishRegistrationSteps.this.allowOriginSubdomain), (String)("Incorrect origin: " + responseOrigin), (Object[])new Object[0]);
        }

        @Override
        public Step10 nextStep() {
            return new Step10(this.clientData);
        }

        @Generated
        public Step9(CollectedClientData clientData) {
            this.clientData = clientData;
        }

        @Generated
        public CollectedClientData getClientData() {
            return this.clientData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step9)) {
                return false;
            }
            Step9 other = (Step9)o;
            CollectedClientData this$clientData = this.getClientData();
            CollectedClientData other$clientData = other.getClientData();
            return !(this$clientData == null ? other$clientData != null : !((Object)this$clientData).equals(other$clientData));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CollectedClientData $clientData = this.getClientData();
            result = result * 59 + ($clientData == null ? 43 : ((Object)$clientData).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step9(clientData=" + this.getClientData() + ")";
        }
    }

    final class Step8
    implements Step<Step9> {
        private final CollectedClientData clientData;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((boolean)FinishRegistrationSteps.this.request.getChallenge().equals(this.clientData.getChallenge()), (String)"Incorrect challenge.", (Object[])new Object[0]);
        }

        @Override
        public Step9 nextStep() {
            return new Step9(this.clientData);
        }

        @Generated
        public Step8(CollectedClientData clientData) {
            this.clientData = clientData;
        }

        @Generated
        public CollectedClientData getClientData() {
            return this.clientData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step8)) {
                return false;
            }
            Step8 other = (Step8)o;
            CollectedClientData this$clientData = this.getClientData();
            CollectedClientData other$clientData = other.getClientData();
            return !(this$clientData == null ? other$clientData != null : !((Object)this$clientData).equals(other$clientData));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CollectedClientData $clientData = this.getClientData();
            result = result * 59 + ($clientData == null ? 43 : ((Object)$clientData).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step8(clientData=" + this.getClientData() + ")";
        }
    }

    final class Step7
    implements Step<Step8> {
        private final CollectedClientData clientData;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((boolean)FinishRegistrationSteps.CLIENT_DATA_TYPE.equals(this.clientData.getType()), (String)"The \"type\" in the client data must be exactly \"%s\", was: %s", (Object[])new Object[]{FinishRegistrationSteps.CLIENT_DATA_TYPE, this.clientData.getType()});
        }

        @Override
        public Step8 nextStep() {
            return new Step8(this.clientData);
        }

        @Generated
        public Step7(CollectedClientData clientData) {
            this.clientData = clientData;
        }

        @Generated
        public CollectedClientData getClientData() {
            return this.clientData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step7)) {
                return false;
            }
            Step7 other = (Step7)o;
            CollectedClientData this$clientData = this.getClientData();
            CollectedClientData other$clientData = other.getClientData();
            return !(this$clientData == null ? other$clientData != null : !((Object)this$clientData).equals(other$clientData));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CollectedClientData $clientData = this.getClientData();
            result = result * 59 + ($clientData == null ? 43 : ((Object)$clientData).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishRegistrationSteps.Step7(clientData=" + this.getClientData() + ")";
        }
    }

    static interface Step<Next extends Step<?>> {
        public Next nextStep();

        public void validate();

        default public Optional<RegistrationResult> result() {
            return Optional.empty();
        }

        default public Next next() {
            this.validate();
            return this.nextStep();
        }

        default public RegistrationResult run() {
            if (this.result().isPresent()) {
                return this.result().get();
            }
            return this.next().run();
        }
    }
}

