/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.storage.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.yubico.webauthn.data.ByteArray;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.webauthn.storage.CredentialRecord;
import net.shibboleth.idp.plugin.authn.webauthn.storage.WebAuthnCredentialRepository;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.CacheService;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.CacheServiceImpl;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.DisabledCacheServiceImpl;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.IdPStorageServiceCredentialRepository;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.QueryByAllStrategy;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.QueryByCredentialIdStrategy;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.QueryByUserHandleStrategy;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.ReadAllCacheLoadingStrategy;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.StrategyBasedIdPStorageServiceCredentialRepository;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.WebAuthnJDBCAccelerator;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.WebAuthnJDBCQueryAccelerator;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.WebAuthnJDBCReadAllAccelerator;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.storage.EnumeratableStorageService;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.springframework.beans.factory.FactoryBean;

@ThreadSafe
public class StorageServiceCredentialRepositoryFactory
extends AbstractInitializableComponent
implements FactoryBean<WebAuthnCredentialRepository> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StorageServiceCredentialRepositoryFactory.class);
    @NonnullAfterInit
    @GuardedBy(value="this")
    private EnumeratableStorageService storageService;
    @Nullable
    @GuardedBy(value="this")
    private WebAuthnJDBCAccelerator jdbcAccelerator;
    @NonnullAfterInit
    @GuardedBy(value="this")
    private StorageSerializer<Set<CredentialRecord>> serializer;
    @Nonnull
    @GuardedBy(value="this")
    private Duration expireAfterAccess;
    private boolean enableCache = true;
    @Nullable
    @GuardedBy(value="this")
    private BiFunction<String, ByteArray, List<StorageRecord<Set<CredentialRecord>>>> credentialByUserHandleLookupStrategy;
    @Nullable
    @GuardedBy(value="this")
    private BiFunction<String, ByteArray, List<StorageRecord<Set<CredentialRecord>>>> credentialByCredentialIdLookupStrategy;
    @Nonnull
    private AcceleratorType defaultAcceleratorType;
    @Nullable
    @GuardedBy(value="this")
    private Function<String, List<StorageRecord<Set<CredentialRecord>>>> storageRecordCacheLoader;

    public StorageServiceCredentialRepositoryFactory() {
        Duration duration = Duration.ofMinutes(60L);
        assert (duration != null);
        this.expireAfterAccess = duration;
        this.defaultAcceleratorType = AcceleratorType.READALL;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.storageService == null) {
            throw new ComponentInitializationException("storageService cannot be null");
        }
        if (this.serializer == null) {
            throw new ComponentInitializationException("Storage service serializer cannot be null");
        }
    }

    public synchronized void setDefaultAcceleratorType(@Nonnull AcceleratorType type) {
        this.checkSetterPreconditions();
        this.defaultAcceleratorType = (AcceleratorType)((Object)Constraint.isNotNull((Object)((Object)type), (String)"defaultAcceleratorType can not be null"));
    }

    @Nonnull
    public synchronized AcceleratorType getDefaultAcceleratorType() {
        return this.defaultAcceleratorType;
    }

    public synchronized void setExpireAfterAccess(@Nonnull Duration expiry) {
        this.checkSetterPreconditions();
        this.expireAfterAccess = (Duration)Constraint.isNotNull((Object)expiry, (String)"ExpireAfterAccess can not be null");
        Constraint.isFalse((expiry.isNegative() || expiry.isZero() ? 1 : 0) != 0, (String)"ExpireAfterAccess must be greater than 0");
    }

    public synchronized void setJdbcAccelerator(@Nullable WebAuthnJDBCQueryAccelerator accelerator) {
        this.checkSetterPreconditions();
        if (accelerator != null) {
            this.jdbcAccelerator = accelerator;
        }
    }

    @Nullable
    private synchronized WebAuthnJDBCAccelerator getJdbcAccelerator() {
        this.checkComponentActive();
        return this.jdbcAccelerator;
    }

    public synchronized void setEnableCache(boolean flag) {
        this.checkSetterPreconditions();
        this.enableCache = flag;
    }

    private synchronized boolean isEnableCache() {
        return this.enableCache;
    }

    public synchronized void setStorageService(@Nonnull StorageService service) {
        EnumeratableStorageService ess;
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)service, (String)"The Storage Service can not be null");
        if (!(service instanceof EnumeratableStorageService)) {
            throw new ConstraintViolationException("Credential repository requires an WebAuthnJDBCStorageService type");
        }
        this.storageService = ess = (EnumeratableStorageService)service;
        StorageCapabilities caps = this.storageService.getCapabilities();
        if (caps instanceof StorageCapabilities) {
            if (!caps.isServerSide()) {
                this.log.info("Use of client-side storage can make it difficult/impossible to transfer key registrations from one browser to another, which can hinder portability");
            }
            if (!caps.isClustered()) {
                this.log.info("Use of non-clustered storage service will result in per-node lockout behavior");
            }
        }
    }

    @NonnullAfterInit
    public synchronized EnumeratableStorageService getStorageService() {
        return this.storageService;
    }

    public synchronized void setSerializer(@Nonnull StorageSerializer<Set<CredentialRecord>> storageSerializer) {
        this.checkSetterPreconditions();
        this.serializer = (StorageSerializer)Constraint.isNotNull(storageSerializer, (String)"serializer can not be null");
    }

    @NonnullAfterInit
    public synchronized StorageSerializer<Set<CredentialRecord>> getSerializer() {
        return this.serializer;
    }

    public synchronized void setCredentialByUserHandleLookupStrategy(@Nullable BiFunction<String, ByteArray, List<StorageRecord<Set<CredentialRecord>>>> strategy) {
        this.checkSetterPreconditions();
        this.credentialByUserHandleLookupStrategy = strategy;
    }

    private synchronized BiFunction<String, ByteArray, List<StorageRecord<Set<CredentialRecord>>>> getCredentialByUserHandleLookupStrategy() {
        return this.credentialByUserHandleLookupStrategy;
    }

    public synchronized void setCredentialByCredentialIdLookupStrategy(@Nullable BiFunction<String, ByteArray, List<StorageRecord<Set<CredentialRecord>>>> strategy) {
        this.checkSetterPreconditions();
        this.credentialByCredentialIdLookupStrategy = strategy;
    }

    private synchronized BiFunction<String, ByteArray, List<StorageRecord<Set<CredentialRecord>>>> getCredentialByCredentialIdLookupStrategy() {
        return this.credentialByCredentialIdLookupStrategy;
    }

    public synchronized void setStorageRecordCacheLoader(@Nullable Function<String, List<StorageRecord<Set<CredentialRecord>>>> loader) {
        this.checkSetterPreconditions();
        this.storageRecordCacheLoader = loader;
    }

    @Nullable
    public synchronized Function<String, List<StorageRecord<Set<CredentialRecord>>>> getStorageRecordCacheLoader() {
        return this.storageRecordCacheLoader;
    }

    public WebAuthnCredentialRepository getObject() throws Exception {
        DisabledCacheServiceImpl credentialIdCacheService;
        DisabledCacheServiceImpl userHandleCacheService = this.isEnableCache() ? CacheServiceImpl.builder().withCache((Cache<String, String>)CacheBuilder.newBuilder().expireAfterAccess(this.expireAfterAccess).build()).withKeyExtractionStrategy(new UserHandleB64FromCredentialExtractionStrategy()).withLookupKeyExtractionStrategy(new Base64URLKeyExtractionStrategy()).withValueExtractionStrategy(new UsernameFromCredentialExtractionStrategy()).build() : new DisabledCacheServiceImpl();
        CacheService cacheService = credentialIdCacheService = this.isEnableCache() ? CacheServiceImpl.builder().withCache((Cache<String, String>)CacheBuilder.newBuilder().expireAfterAccess(this.expireAfterAccess).build()).withKeyExtractionStrategy(new CredentialIdB64FromCredentialExtractionStrategy()).withLookupKeyExtractionStrategy(new Base64URLKeyExtractionStrategy()).withValueExtractionStrategy(new UsernameFromCredentialExtractionStrategy()).build() : new DisabledCacheServiceImpl();
        if (this.getCredentialByUserHandleLookupStrategy() != null && this.getCredentialByCredentialIdLookupStrategy() != null) {
            this.log.debug("Constructing custom userHandle and credentialId lookup repository");
            StrategyBasedIdPStorageServiceCredentialRepository repo = new StrategyBasedIdPStorageServiceCredentialRepository();
            repo.setStorageService((StorageService)this.getStorageService());
            repo.setSerializer(this.getSerializer());
            repo.setUserHandleMappingCacheService(userHandleCacheService);
            repo.setCredentialIdMappingCacheService(credentialIdCacheService);
            repo.setId("StrategyBasedIdPStorageServiceCredentialRepository");
            repo.setCredentialByUserHandleLookupStrategy(this.getCredentialByUserHandleLookupStrategy());
            repo.setCredentialByCredentialIdLookupStrategy(this.getCredentialByCredentialIdLookupStrategy());
            if (this.getStorageRecordCacheLoader() != null) {
                repo.setStorageRecordCacheLoader(this.getStorageRecordCacheLoader());
            }
            repo.initialize();
            return repo;
        }
        if (this.jdbcAccelerator != null) {
            WebAuthnJDBCAccelerator webAuthnJDBCAccelerator;
            WebAuthnJDBCReadAllAccelerator accelerator;
            WebAuthnJDBCAccelerator accelerator2;
            WebAuthnJDBCAccelerator webAuthnJDBCAccelerator2;
            this.log.debug("Constructing accelerated JDBC credential repository");
            StrategyBasedIdPStorageServiceCredentialRepository repo = new StrategyBasedIdPStorageServiceCredentialRepository();
            repo.setStorageService((StorageService)this.getStorageService());
            repo.setSerializer(this.getSerializer());
            repo.setUserHandleMappingCacheService(userHandleCacheService);
            repo.setCredentialIdMappingCacheService(credentialIdCacheService);
            if (this.defaultAcceleratorType == AcceleratorType.QUERY && (webAuthnJDBCAccelerator2 = this.getJdbcAccelerator()) instanceof WebAuthnJDBCQueryAccelerator) {
                accelerator2 = (WebAuthnJDBCQueryAccelerator)webAuthnJDBCAccelerator2;
                repo.setCredentialByUserHandleLookupStrategy(new QueryByUserHandleStrategy((WebAuthnJDBCQueryAccelerator)accelerator2));
            } else if (this.defaultAcceleratorType == AcceleratorType.READALL && (webAuthnJDBCAccelerator2 = this.getJdbcAccelerator()) instanceof WebAuthnJDBCReadAllAccelerator) {
                accelerator = (WebAuthnJDBCReadAllAccelerator)webAuthnJDBCAccelerator2;
                repo.setCredentialByUserHandleLookupStrategy(new QueryByAllStrategy(accelerator));
            }
            if (this.defaultAcceleratorType == AcceleratorType.QUERY && (webAuthnJDBCAccelerator2 = this.getJdbcAccelerator()) instanceof WebAuthnJDBCQueryAccelerator) {
                accelerator2 = (WebAuthnJDBCQueryAccelerator)webAuthnJDBCAccelerator2;
                repo.setCredentialByCredentialIdLookupStrategy(new QueryByCredentialIdStrategy((WebAuthnJDBCQueryAccelerator)accelerator2));
            } else if (this.defaultAcceleratorType == AcceleratorType.READALL && (webAuthnJDBCAccelerator2 = this.getJdbcAccelerator()) instanceof WebAuthnJDBCReadAllAccelerator) {
                accelerator = (WebAuthnJDBCReadAllAccelerator)webAuthnJDBCAccelerator2;
                repo.setCredentialByCredentialIdLookupStrategy(new QueryByAllStrategy(accelerator));
            }
            if (this.getStorageRecordCacheLoader() != null) {
                repo.setStorageRecordCacheLoader(this.getStorageRecordCacheLoader());
            } else if (this.defaultAcceleratorType == AcceleratorType.READALL && (webAuthnJDBCAccelerator = this.getJdbcAccelerator()) instanceof WebAuthnJDBCReadAllAccelerator) {
                accelerator2 = (WebAuthnJDBCReadAllAccelerator)webAuthnJDBCAccelerator;
                repo.setStorageRecordCacheLoader(new ReadAllCacheLoadingStrategy((WebAuthnJDBCReadAllAccelerator)accelerator2));
            } else {
                repo.setStorageRecordCacheLoader(context -> CollectionSupport.emptyList());
            }
            repo.setId("StrategyBasedIdPStorageServiceCredentialRepository");
            repo.initialize();
            return repo;
        }
        IdPStorageServiceCredentialRepository repo = new IdPStorageServiceCredentialRepository();
        repo.setStorageService((StorageService)this.getStorageService());
        repo.setSerializer(this.getSerializer());
        repo.setUserHandleMappingCacheService(userHandleCacheService);
        repo.setCredentialIdMappingCacheService(credentialIdCacheService);
        if (this.getStorageRecordCacheLoader() != null) {
            repo.setStorageRecordCacheLoader(this.getStorageRecordCacheLoader());
        }
        repo.setId("IdPStorageServiceCredentialRepository");
        repo.initialize();
        return repo;
    }

    public Class<?> getObjectType() {
        return WebAuthnCredentialRepository.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public static enum AcceleratorType {
        QUERY,
        READALL;

    }

    static class UserHandleB64FromCredentialExtractionStrategy
    implements Function<CredentialRecord, String> {
        UserHandleB64FromCredentialExtractionStrategy() {
        }

        @Override
        public String apply(CredentialRecord cred) {
            return cred.getCredential().getUserHandle().getBase64Url();
        }
    }

    static class Base64URLKeyExtractionStrategy
    implements Function<ByteArray, String> {
        Base64URLKeyExtractionStrategy() {
        }

        @Override
        public String apply(ByteArray byteArray) {
            return byteArray.getBase64Url();
        }
    }

    static class UsernameFromCredentialExtractionStrategy
    implements Function<CredentialRecord, String> {
        UsernameFromCredentialExtractionStrategy() {
        }

        @Override
        public String apply(CredentialRecord cred) {
            return cred.getUsername();
        }
    }

    static class CredentialIdB64FromCredentialExtractionStrategy
    implements Function<CredentialRecord, String> {
        CredentialIdB64FromCredentialExtractionStrategy() {
        }

        @Override
        public String apply(CredentialRecord cred) {
            return cred.getCredential().getCredentialId().getBase64Url();
        }
    }
}

