/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.storage.impl;

import com.yubico.webauthn.data.ByteArray;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.webauthn.exception.CredentialRepositoryException;
import net.shibboleth.idp.plugin.authn.webauthn.storage.CredentialRecord;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.WebAuthnJDBCReadAllAccelerator;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.storage.StorageRecord;

public class QueryByAllStrategy
implements BiFunction<String, ByteArray, List<StorageRecord<Set<CredentialRecord>>>> {
    @Nonnull
    private final WebAuthnJDBCReadAllAccelerator queryAccelerator;

    public QueryByAllStrategy(@Nonnull WebAuthnJDBCReadAllAccelerator accelerator) {
        this.queryAccelerator = (WebAuthnJDBCReadAllAccelerator)Constraint.isNotNull((Object)accelerator, (String)"Accelerator can not be empty");
    }

    @Override
    public List<StorageRecord<Set<CredentialRecord>>> apply(String storageContext, ByteArray credentialId) {
        if (storageContext == null) {
            throw new CredentialRepositoryException("Storage context can not be null");
        }
        try {
            return this.queryAccelerator.readAll(storageContext);
        }
        catch (IOException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
    }
}

