/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.impl;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.webauthn.context.WebAuthnAuthenticationContext;
import net.shibboleth.idp.plugin.authn.webauthn.impl.AbstractWebAuthnAction;
import net.shibboleth.idp.plugin.authn.webauthn.policy.CredentialPolicy;
import net.shibboleth.idp.plugin.authn.webauthn.storage.EnhancedCredentialRecord;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class FilterCredentialsOnPolicy
extends AbstractWebAuthnAction<WebAuthnAuthenticationContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterCredentialsOnPolicy.class);
    @Nullable
    private CredentialPolicy credentialPolicy;
    @Nonnull
    @NotEmpty
    private String noCredentialsEventId = "NoCredentials";

    protected FilterCredentialsOnPolicy() {
        super(new ChildContextLookup(WebAuthnAuthenticationContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class)));
    }

    public void setNoCredentialsEventId(@Nonnull @NotEmpty String eventId) {
        this.checkSetterPreconditions();
        this.noCredentialsEventId = Constraint.isNotEmpty((String)eventId, (String)"NoCredentialsEventId can not be null or empty");
    }

    public void setCredentialPolicy(@Nullable CredentialPolicy policy) {
        this.checkSetterPreconditions();
        this.credentialPolicy = policy;
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull WebAuthnAuthenticationContext context) {
        CredentialPolicy localPolicy = this.credentialPolicy;
        if (localPolicy == null) {
            this.log.trace("{} No authenticator policy to apply", (Object)this.getLogPrefix());
            return;
        }
        Collection existingCredentials = context.getExistingCredentials();
        if (existingCredentials.isEmpty()) {
            this.log.trace("{} User '{}' does not have any registered credentials, policy can not be applied", (Object)this.getLogPrefix(), (Object)context.getUsername());
            return;
        }
        this.log.debug("{} User '{}' has '{}' credentials before policy filtering", new Object[]{this.getLogPrefix(), context.getUsername(), existingCredentials.size()});
        List<EnhancedCredentialRecord> filteredCredentials = existingCredentials.stream().filter(credentialToEvaluate -> {
            CredentialPolicy.CredentialPolicyOutcome outcome = localPolicy.evaluate(credentialToEvaluate, profileRequestContext);
            if (outcome == CredentialPolicy.CredentialPolicyOutcome.ACCEPT) {
                this.log.trace("{} CredentialPolicy '{}' has accepted credential '{}'", new Object[]{this.getLogPrefix(), localPolicy.getId(), credentialToEvaluate.getCredentialRecord().getCredentialIdBase64()});
                return true;
            }
            if (outcome == CredentialPolicy.CredentialPolicyOutcome.REJECT) {
                this.log.trace("{} CredentialPolicy '{}' has rejected credential '{}', removing credential", new Object[]{this.getLogPrefix(), localPolicy.getId(), credentialToEvaluate.getCredentialRecord().getCredentialIdBase64()});
                return false;
            }
            if (outcome == CredentialPolicy.CredentialPolicyOutcome.IGNORE) {
                this.log.trace("{} CredentialPolicy '{}' was not active for credential '{}'", new Object[]{this.getLogPrefix(), localPolicy.getId(), credentialToEvaluate.getCredentialRecord().getCredentialIdBase64()});
                return true;
            }
            return true;
        }).toList();
        context.setExistingCredentials(filteredCredentials);
        this.log.debug("{} User '{}' has '{}' credentials after policy filtering", new Object[]{this.getLogPrefix(), context.getUsername(), filteredCredentials.size()});
        if (filteredCredentials.isEmpty()) {
            this.log.debug("{} All of '{}'s' credentials have been filtered, triggering event '{}' ", new Object[]{this.getLogPrefix(), context.getUsername(), this.noCredentialsEventId});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)this.noCredentialsEventId);
            return;
        }
    }
}

