/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.client.impl;

import com.yubico.webauthn.AssertionRequest;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.FinishAssertionOptions;
import com.yubico.webauthn.FinishRegistrationOptions;
import com.yubico.webauthn.RelyingParty;
import com.yubico.webauthn.data.AttestationType;
import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.AuthenticatorAttestationResponse;
import com.yubico.webauthn.data.AuthenticatorSelectionCriteria;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import com.yubico.webauthn.data.ClientRegistrationExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialCreationOptions;
import com.yubico.webauthn.data.PublicKeyCredentialParameters;
import com.yubico.webauthn.data.PublicKeyCredentialRequestOptions;
import com.yubico.webauthn.data.RegistrationExtensionInputs;
import com.yubico.webauthn.data.UserIdentity;
import com.yubico.webauthn.exception.RegistrationFailedException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.webauthn.admin.CredentialCreationOptionsParameters;
import net.shibboleth.idp.plugin.authn.webauthn.admin.RegistrationResult;
import net.shibboleth.idp.plugin.authn.webauthn.authn.CredentialRequestOptionsParameters;
import net.shibboleth.idp.plugin.authn.webauthn.client.WebAuthnAuthenticationClient;
import net.shibboleth.idp.plugin.authn.webauthn.exception.AssertionFailureException;
import net.shibboleth.idp.plugin.authn.webauthn.exception.RegistrationFailureException;
import net.shibboleth.idp.plugin.authn.webauthn.exception.WebAuthnAuthenticationClientException;
import net.shibboleth.idp.plugin.authn.webauthn.impl.WebAuthnSupport;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
public class YubicoWebAuthnAuthenticationClient
implements WebAuthnAuthenticationClient {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(YubicoWebAuthnAuthenticationClient.class);
    @Nonnull
    private final RelyingParty rp;
    @Nonnull
    @NonnullElements
    @NotLive
    private final List<PublicKeyCredentialParameters> preferredPublickeyParams;

    YubicoWebAuthnAuthenticationClient(@Nonnull RelyingParty relyingParty, @Nonnull @NonnullElements @NotLive List<PublicKeyCredentialParameters> publickeyParams) {
        this.rp = (RelyingParty)Constraint.isNotNull((Object)relyingParty, (String)"The reyling party configuration can not be null");
        this.preferredPublickeyParams = (List)Constraint.isNotNull(publickeyParams, (String)"PreferredPublickeyParams can not be null");
    }

    public PublicKeyCredentialRequestOptions createAuthenticationRequest(@Nonnull CredentialRequestOptionsParameters requestParams) throws WebAuthnAuthenticationClientException {
        PublicKeyCredentialRequestOptions request = PublicKeyCredentialRequestOptions.builder().challenge(new ByteArray(requestParams.getChallenge())).rpId(this.rp.getIdentity().getId()).allowCredentials(Optional.ofNullable(requestParams.getAllowCredentials())).userVerification(requestParams.getUserVerificationRequirement()).timeout(Optional.of(60000L)).build();
        if (request == null) {
            throw new WebAuthnAuthenticationClientException("Unable to build public key credential request options");
        }
        return request;
    }

    public PublicKeyCredentialCreationOptions createRegistrationRequest(@Nonnull CredentialCreationOptionsParameters creationOptions) throws WebAuthnAuthenticationClientException {
        UserIdentity identity = UserIdentity.builder().name(creationOptions.getName()).displayName(creationOptions.getDisplayName()).id(new ByteArray(creationOptions.getUserId())).build();
        RegistrationExtensionInputs extensions = creationOptions.isEnableCredProperties() ? RegistrationExtensionInputs.builder().credProps().build() : RegistrationExtensionInputs.builder().build();
        PublicKeyCredentialCreationOptions creation = PublicKeyCredentialCreationOptions.builder().rp(this.rp.getIdentity()).user(identity).challenge(new ByteArray(creationOptions.getChallenge())).pubKeyCredParams(this.preferredPublickeyParams).excludeCredentials(creationOptions.getExcludeCredentials()).attestation(creationOptions.getAttestationConveyancePreference()).authenticatorSelection(AuthenticatorSelectionCriteria.builder().userVerification(creationOptions.getUserVerificationRequirement()).residentKey(creationOptions.getResidentKeyRequirement()).authenticatorAttachment(creationOptions.getAuthenticatorAttachment()).build()).extensions(extensions).timeout(Optional.empty()).build();
        if (creation == null) {
            throw new WebAuthnAuthenticationClientException("Unable to build public key credential creation options");
        }
        return creation;
    }

    public net.shibboleth.idp.plugin.authn.webauthn.authn.AssertionResult validateAuthenticatorAssertionResponse(@Nullable String username, @Nullable byte[] userId, @Nonnull PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, @Nonnull PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> authenticatorAssertionResponse) throws AssertionFailureException {
        try {
            AssertionResult result;
            AssertionRequest requestAssertion = AssertionRequest.builder().publicKeyCredentialRequestOptions(publicKeyCredentialRequestOptions).userHandle(Optional.ofNullable(userId != null ? new ByteArray(userId) : null)).username(Optional.ofNullable(username)).build();
            if (this.log.isDebugEnabled()) {
                if (username == null && userId == null) {
                    Optional userHandleOptional = ((AuthenticatorAssertionResponse)authenticatorAssertionResponse.getResponse()).getUserHandle();
                    ByteArray userHandle = userHandleOptional.isPresent() ? (ByteArray)userHandleOptional.get() : null;
                    String userHandleBase64 = userHandle != null ? WebAuthnSupport.toBase64OrUnknown(userHandle.getBytes()) : "unknown";
                    this.log.debug("Attempting validation of assumed discoverable credential with userHandle from response '{}'", (Object)userHandleBase64);
                } else {
                    this.log.debug("Attempting validation of credential '{}' with request username '{}' and request userHandle '{}'", new Object[]{authenticatorAssertionResponse.getId().getBase64(), username, WebAuthnSupport.toBase64OrUnknown(userId)});
                }
            }
            if ((result = this.rp.finishAssertion(FinishAssertionOptions.builder().request(requestAssertion).response(authenticatorAssertionResponse).build())) == null) {
                throw new AssertionFailureException("Unable to validate authenticator assertion, null result");
            }
            if (!result.isSuccess()) {
                throw new AssertionFailureException("Authenticator assertion was not valid");
            }
            net.shibboleth.idp.plugin.authn.webauthn.authn.AssertionResult assertionResult = net.shibboleth.idp.plugin.authn.webauthn.authn.AssertionResult.builder().withSuccess(result.isSuccess()).withUsername(result.getUsername()).withSignatureCounterValid(result.isSignatureCounterValid()).withUserId(result.getCredential().getUserHandle().getBytes()).withUserVerified(result.isUserVerified()).build();
            assert (assertionResult != null);
            return assertionResult;
        }
        catch (Exception e) {
            throw new AssertionFailureException((Throwable)e);
        }
    }

    public RegistrationResult validateAuthenticatorAttestationResponse(@Nonnull PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions, @Nonnull PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> authenticatorAttestationResponse) throws RegistrationFailureException {
        try {
            this.log.debug("Attempting validation of public key credential attestation '{}'", authenticatorAttestationResponse);
            com.yubico.webauthn.RegistrationResult result = this.rp.finishRegistration(FinishRegistrationOptions.builder().request(publicKeyCredentialCreationOptions).response(authenticatorAttestationResponse).build());
            AttestationType type = result.getAttestationType();
            if (type == null) {
                throw new RegistrationFailureException("Attestation type was null");
            }
            RegistrationResult registrationResult = RegistrationResult.builder().withAttestationTrusted(result.isAttestationTrusted()).withAttestationType(type).withCredential(authenticatorAttestationResponse).build();
            assert (registrationResult != null);
            return registrationResult;
        }
        catch (RegistrationFailedException e) {
            throw new RegistrationFailureException((Throwable)e);
        }
    }
}

