/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.admin.impl;

import com.yubico.webauthn.data.ByteArray;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.webauthn.audit.impl.AbstractWebAuthnAuditingAction;
import net.shibboleth.idp.plugin.authn.webauthn.context.WebAuthnRegistrationContext;
import net.shibboleth.idp.plugin.authn.webauthn.storage.WebAuthnCredentialRepository;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class UpdateCredentialNickname
extends AbstractWebAuthnAuditingAction<WebAuthnRegistrationContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(UpdateCredentialNickname.class);
    @NonnullAfterInit
    private WebAuthnCredentialRepository repository;

    protected UpdateCredentialNickname() {
        super(new ChildContextLookup(WebAuthnRegistrationContext.class));
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.repository = this.getCredentialRepository();
        if (this.repository == null) {
            throw new ComponentInitializationException("Credential repository can not be null");
        }
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull WebAuthnRegistrationContext context) {
        String username = context.getUsername();
        if (username == null) {
            this.log.error("{} Unable to find username in registration context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRegistrationContext");
            return;
        }
        byte[] credentialId = context.getCredentialIdToModify();
        if (credentialId == null) {
            this.log.error("{} Unable to find credentialId in registration context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRegistrationContext");
            return;
        }
        ByteArray credentialIdAsByteArray = new ByteArray(credentialId);
        String nickname = context.getCredentialNickname();
        if (StringSupport.trimOrNull((String)nickname) == null) {
            this.log.error("{} Unable to find nickname in registration context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRegistrationContext");
            return;
        }
        boolean updated = this.repository.updateNickname(username, credentialIdAsByteArray, nickname);
        this.log.info("{} Credential '{}' {} updated for user '{}'", new Object[]{this.getLogPrefix(), credentialIdAsByteArray.getBase64(), updated ? "was" : "was not", username});
        if (updated) {
            this.auditSuccess(profileRequestContext, "credential-updated");
        } else {
            this.auditFailure(profileRequestContext, "credential-updated");
        }
        context.setCredentialIdToModify(null);
    }
}

