/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.storage.impl;

import com.yubico.webauthn.data.ByteArray;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.webauthn.exception.CredentialRepositoryException;
import net.shibboleth.idp.plugin.authn.webauthn.storage.CredentialRecord;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.IdPStorageServiceCredentialRepository;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class StrategyBasedIdPStorageServiceCredentialRepository
extends IdPStorageServiceCredentialRepository {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StrategyBasedIdPStorageServiceCredentialRepository.class);
    @NonnullAfterInit
    private BiFunction<String, ByteArray, List<StorageRecord<Set<CredentialRecord>>>> credentialByUserHandleLookupStrategy;
    @NonnullAfterInit
    private BiFunction<String, ByteArray, List<StorageRecord<Set<CredentialRecord>>>> credentialByCredentialIdLookupStrategy;

    StrategyBasedIdPStorageServiceCredentialRepository() {
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if (this.credentialByCredentialIdLookupStrategy == null) {
            throw new ComponentInitializationException("Credential lookup by CredentialId lookup strategy can not be null");
        }
        if (this.credentialByUserHandleLookupStrategy == null) {
            throw new ComponentInitializationException("Credential lookup by UserHandle lookup strategy can not be null");
        }
        super.doInitialize();
    }

    public void setCredentialByUserHandleLookupStrategy(@Nonnull BiFunction<String, ByteArray, List<StorageRecord<Set<CredentialRecord>>>> strategy) {
        this.checkSetterPreconditions();
        this.credentialByUserHandleLookupStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"userHandleLookupStrategy can not be null");
    }

    public void setCredentialByCredentialIdLookupStrategy(@Nonnull BiFunction<String, ByteArray, List<StorageRecord<Set<CredentialRecord>>>> strategy) {
        this.checkSetterPreconditions();
        this.credentialByCredentialIdLookupStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"credentialIdLookupStrategy can not be null");
    }

    @Override
    @Nonnull
    protected Collection<CredentialRecord> getRegistrationsByUserHandle(ByteArray userHandle) {
        this.checkComponentActive();
        ReentrantReadWriteLock.ReadLock readLock = this.getLock().readLock();
        try {
            readLock.lock();
            String userHandleB64 = userHandle.getBase64Url();
            assert (userHandleB64 != null);
            List<StorageRecord<Set<CredentialRecord>>> records = this.credentialByUserHandleLookupStrategy.apply("net.shibboleth.idp.plugin.authn.webauthn", userHandle);
            this.log.trace("{}: Found '{}' unfiltered credential record(s) from the storage service for userHandle '{}'", new Object[]{this.getId(), records != null ? Integer.valueOf(records.size()) : "null", userHandleB64});
            if (records == null) {
                Set set = CollectionSupport.emptySet();
                return set;
            }
            HashSet allCredentialRecords = new HashSet();
            for (StorageRecord<Set<CredentialRecord>> storageRecord : records) {
                Set credentials = (Set)storageRecord.getValue(this.getSerializer(), "net.shibboleth.idp.plugin.authn.webauthn", userHandleB64);
                allCredentialRecords.addAll(credentials);
            }
            Set matchingCredentials = (Set)((NonnullSupplier)allCredentialRecords.stream().filter(cred -> userHandle.equals((Object)cred.getUserIdentity().getId())).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get();
            this.log.debug("{}: Found '{}' matching credential(s) for userHandle '{}'", new Object[]{this.getId(), matchingCredentials.size(), userHandleB64});
            Set set = matchingCredentials;
            return set;
        }
        catch (IOException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    @Nonnull
    protected Set<CredentialRecord> getRegistrationsByCredentialId(ByteArray credentialId) {
        this.checkComponentActive();
        ReentrantReadWriteLock.ReadLock readLock = this.getLock().readLock();
        try {
            Set set;
            readLock.lock();
            String credentialIdB64 = credentialId.getBase64Url();
            assert (credentialIdB64 != null);
            List<StorageRecord<Set<CredentialRecord>>> records = this.credentialByCredentialIdLookupStrategy.apply("net.shibboleth.idp.plugin.authn.webauthn", credentialId);
            this.log.trace("{}: Found '{}' unflitered credential record(s) from the storage service for credential '{}'", new Object[]{this.getId(), records != null ? Integer.valueOf(records.size()) : "null", credentialIdB64});
            if (records == null) {
                Set set2 = CollectionSupport.emptySet();
                return set2;
            }
            HashSet allCredentialRecords = new HashSet();
            for (StorageRecord<Set<CredentialRecord>> storageRecord : records) {
                StorageSerializer<Set<CredentialRecord>> serializer = this.getSerializer();
                assert (serializer != null);
                Set credentials = (Set)storageRecord.getValue(serializer, "net.shibboleth.idp.plugin.authn.webauthn", credentialIdB64);
                allCredentialRecords.addAll(credentials);
            }
            Set matchingCredentials = (Set)((NonnullSupplier)allCredentialRecords.stream().filter(cred -> credentialId.equals((Object)cred.getCredential().getCredentialId())).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get();
            this.log.info("{}: Found '{}' matching credentials for credentialId '{}'", new Object[]{this.getId(), matchingCredentials.size(), credentialIdB64});
            if (!matchingCredentials.isEmpty()) {
                set = (Set)((NonnullSupplier)matchingCredentials.stream().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get();
                return set;
            }
            set = CollectionSupport.emptySet();
            return set;
        }
        catch (IOException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
        finally {
            readLock.unlock();
        }
    }
}

