/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.storage.impl;

import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.webauthn.exception.CredentialRepositoryException;
import net.shibboleth.idp.plugin.authn.webauthn.storage.CredentialRecord;
import net.shibboleth.idp.plugin.authn.webauthn.storage.WebAuthnCredentialRepository;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.CacheService;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.storage.EnumeratableStorageService;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.VersionMismatchException;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class IdPStorageServiceCredentialRepository
extends AbstractIdentifiableInitializableComponent
implements WebAuthnCredentialRepository {
    @Nonnull
    @NotEmpty
    protected static final String STORAGE_CONTEXT = "net.shibboleth.idp.plugin.authn.webauthn";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IdPStorageServiceCredentialRepository.class);
    @NonnullAfterInit
    private StorageSerializer<Set<CredentialRecord>> serializer;
    @NonnullAfterInit
    private EnumeratableStorageService storageService;
    @NonnullAfterInit
    private ReentrantReadWriteLock lock;
    @NonnullAfterInit
    private CacheService userHandleMappingCacheService;
    @NonnullAfterInit
    private CacheService credentialIdMappingCacheService;
    @Nonnull
    private Function<String, List<StorageRecord<Set<CredentialRecord>>>> storageRecordCacheLoader = context -> CollectionSupport.emptyList();

    IdPStorageServiceCredentialRepository() {
    }

    @NonnullAfterInit
    protected ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public void setUserHandleMappingCacheService(@Nonnull CacheService cache) {
        this.checkSetterPreconditions();
        this.userHandleMappingCacheService = (CacheService)Constraint.isNotNull((Object)cache, (String)"Cache service can not be null");
    }

    @NonnullAfterInit
    protected CacheService getUserHandleMappingCacheService() {
        this.checkComponentActive();
        return this.userHandleMappingCacheService;
    }

    public void setCredentialIdMappingCacheService(@Nonnull CacheService cache) {
        this.checkSetterPreconditions();
        this.credentialIdMappingCacheService = (CacheService)Constraint.isNotNull((Object)cache, (String)"Cache service can not be null");
    }

    @NonnullAfterInit
    protected CacheService getCredentialIdMappingCacheService() {
        this.checkComponentActive();
        return this.credentialIdMappingCacheService;
    }

    public void setStorageRecordCacheLoader(@Nonnull Function<String, List<StorageRecord<Set<CredentialRecord>>>> loader) {
        this.checkSetterPreconditions();
        this.storageRecordCacheLoader = (Function)Constraint.isNotNull(loader, (String)"initialCacheLoader can not be null");
    }

    public void setStorageService(@Nonnull StorageService service) {
        EnumeratableStorageService ess;
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)service, (String)"The Storage Service can not be null");
        if (!(service instanceof EnumeratableStorageService)) {
            throw new ConstraintViolationException("Credential repository requires an EnumeratableStorageService type");
        }
        this.storageService = ess = (EnumeratableStorageService)service;
        StorageCapabilities caps = this.storageService.getCapabilities();
        if (caps instanceof StorageCapabilities) {
            if (!caps.isServerSide()) {
                this.log.info("Use of client-side storage can make it difficult/impossible to transfer key registrations from one browser to another, which can hinder portability");
            }
            if (!caps.isClustered()) {
                this.log.info("Use of non-clustered storage service will result in per-node lockout behavior");
            }
        }
    }

    public void setSerializer(@Nonnull StorageSerializer<Set<CredentialRecord>> storageSerializer) {
        this.checkSetterPreconditions();
        this.serializer = (StorageSerializer)Constraint.isNotNull(storageSerializer, (String)"serializer can not be null");
    }

    @NonnullAfterInit
    protected StorageSerializer<Set<CredentialRecord>> getSerializer() {
        return this.serializer;
    }

    protected void doDestroy() {
        this.lock = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.serializer == null) {
            throw new ComponentInitializationException("Storage serializer can not be null");
        }
        if (this.storageService == null) {
            throw new ComponentInitializationException("Storage service can not be null");
        }
        if (this.userHandleMappingCacheService == null) {
            throw new ComponentInitializationException("UserHandle mapping cache service can not be null");
        }
        if (this.credentialIdMappingCacheService == null) {
            throw new ComponentInitializationException("CredentialId mapping cache service can not be null");
        }
        this.lock = new ReentrantReadWriteLock(true);
        this.initialCacheLoad();
    }

    private void initialCacheLoad() {
        try {
            List<StorageRecord<Set<CredentialRecord>>> records = this.storageRecordCacheLoader.apply(STORAGE_CONTEXT);
            if (records != null) {
                this.reloadCache(records);
            }
        }
        catch (Exception e) {
            throw new CredentialRepositoryException(e);
        }
    }

    @Nullable
    protected String getUsernameFromUserHandleCache(@Nonnull ByteArray userHandle) {
        this.checkComponentActive();
        String usernameMapping = this.userHandleMappingCacheService.getIfPresent(userHandle);
        if (usernameMapping != null) {
            Set<CredentialRecord> credentials = this.getRegistrationsByUsername(usernameMapping);
            if (credentials.isEmpty()) {
                this.log.trace("{}: UserHandle '{}' to username '{}' mapping is inconsistent, no registrations found, reloading", new Object[]{this.getId(), userHandle.getBase64Url(), usernameMapping});
                this.userHandleMappingCacheService.invalidate(userHandle);
            } else {
                boolean usernameUserHandleMappingIsValid = credentials.stream().anyMatch(cr -> cr.getUserIdentity().getId().compareTo(userHandle) == 0);
                boolean usernameMappingIsValid = credentials.stream().allMatch(cr -> usernameMapping.equals(cr.getUsername()));
                if (!usernameMappingIsValid) {
                    this.log.trace("{}: UserHandle '{}' to username '{}' mapping is inconsistent, username in mapping does not match the username in the credential, reloading", new Object[]{this.getId(), userHandle.getBase64Url(), usernameMapping});
                    this.userHandleMappingCacheService.invalidate(userHandle);
                } else if (!usernameUserHandleMappingIsValid) {
                    this.log.trace("{}: UserHandle '{}' to username '{}' mapping is inconsistent, userHandle is not present in any of '{}''s credentials, reloading", new Object[]{this.getId(), userHandle.getBase64Url(), usernameMapping, usernameMapping});
                    this.userHandleMappingCacheService.invalidate(userHandle);
                } else {
                    this.log.trace("{}: UserHandle '{}' to username '{}' mapping found in cache", new Object[]{this.getId(), userHandle.getBase64Url(), usernameMapping});
                    return usernameMapping;
                }
            }
        }
        return null;
    }

    @Nullable
    protected String getUsernameFromCredentialIdCache(@Nonnull ByteArray credentialId) {
        this.checkComponentActive();
        String usernameMapping = this.credentialIdMappingCacheService.getIfPresent(credentialId);
        if (usernameMapping != null) {
            Set<CredentialRecord> credentials = this.getRegistrationsByUsername(usernameMapping);
            if (credentials.isEmpty()) {
                this.log.trace("{}: CredentialId '{}' to username '{}' mapping is inconsistent, no registrations found, reloading", new Object[]{this.getId(), credentialId.getBase64Url(), usernameMapping});
                this.credentialIdMappingCacheService.invalidate(credentialId);
            } else {
                boolean usernameCredentialIdMappingIsValid = credentials.stream().anyMatch(cr -> cr.getCredential().getCredentialId().compareTo(credentialId) == 0);
                boolean usernameMappingIsValid = credentials.stream().allMatch(cr -> usernameMapping.equals(cr.getUsername()));
                if (!usernameMappingIsValid) {
                    this.log.trace("{}: CredentialId '{}' to username '{}' mapping is inconsistent, username in mapping does not match the username in the credential, reloading", new Object[]{this.getId(), credentialId.getBase64Url(), usernameMapping});
                    this.credentialIdMappingCacheService.invalidate(credentialId);
                } else if (!usernameCredentialIdMappingIsValid) {
                    this.log.trace("{}: CredentialId '{}' to username '{}' mapping is inconsistent, CredentialId is not present in any of '{}''s credentials, reloading", new Object[]{this.getId(), credentialId.getBase64Url(), usernameMapping, usernameMapping});
                    this.credentialIdMappingCacheService.invalidate(credentialId);
                } else {
                    this.log.trace("{}: CredentialId '{}' to username '{}' mapping found in cache", new Object[]{this.getId(), credentialId.getBase64Url(), usernameMapping});
                    return usernameMapping;
                }
            }
        }
        return null;
    }

    protected void reloadCache(@Nonnull List<StorageRecord<Set<CredentialRecord>>> records) {
        try {
            this.log.trace("Reloading '{}' storage records", (Object)records.size());
            this.userHandleMappingCacheService.invalidateAll();
            if (!records.isEmpty()) {
                for (StorageRecord<Set<CredentialRecord>> credStorageRecord : records) {
                    Set credRecords = (Set)credStorageRecord.getValue(this.getSerializer(), STORAGE_CONTEXT, "not-needed");
                    for (CredentialRecord credential : credRecords) {
                        if (credential == null) continue;
                        this.userHandleMappingCacheService.put(credential);
                        this.credentialIdMappingCacheService.put(credential);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
    }

    protected void updateUserHandleCache(@Nonnull Collection<CredentialRecord> updates) {
        this.checkComponentActive();
        updates.stream().filter(Objects::nonNull).forEach(credential -> this.userHandleMappingCacheService.put((CredentialRecord)credential));
    }

    protected void updateCredentialIdCache(@Nonnull Collection<CredentialRecord> updates) {
        this.checkComponentActive();
        updates.stream().filter(Objects::nonNull).forEach(credential -> this.credentialIdMappingCacheService.put((CredentialRecord)credential));
    }

    protected void updateCache(@Nonnull CredentialRecord update) {
        this.checkComponentActive();
        this.userHandleMappingCacheService.put(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PublicKeyCredentialDescriptor> getCredentialIdsForUsername(@Nullable String username) {
        this.checkComponentActive();
        if (username == null) {
            return CollectionSupport.emptySet();
        }
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Set set = (Set)((NonnullSupplier)this.getRegistrationsByUsername(username).stream().map(reg -> reg.toPublicKeyCredentialDescriptor()).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get();
            return set;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ByteArray> getUserHandleForUsername(@Nullable String username) {
        this.checkComponentActive();
        if (username == null) {
            return Optional.empty();
        }
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Optional<ByteArray> optional = this.getRegistrationsByUsername(username).stream().findAny().map(reg -> reg.getUserIdentity().getId());
            return optional;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> getUsernameForUserHandle(ByteArray userHandle) {
        this.checkComponentActive();
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            assert (userHandle != null);
            String usernameMapping = this.getUsernameFromUserHandleCache(userHandle);
            if (usernameMapping != null) {
                Optional<String> optional = Optional.of(usernameMapping);
                return optional;
            }
            Collection<CredentialRecord> credentials = this.getRegistrationsByUserHandle(userHandle);
            if (credentials.isEmpty()) {
                Optional<String> optional = Optional.empty();
                return optional;
            }
            List<String> usernames = credentials.stream().map(CredentialRecord::getUsername).distinct().toList();
            if (usernames.size() != 1) {
                throw new CredentialRepositoryException("UserHandle maps to more than one username, credential repository is inconsistent");
            }
            this.updateUserHandleCache(credentials);
            Optional<String> optional = Optional.of(credentials.iterator().next().getUsername());
            return optional;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<RegisteredCredential> lookup(ByteArray credentialId, ByteArray userHandle) {
        this.checkComponentActive();
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Optional<RegisteredCredential> optional = this.lookupAll(credentialId).stream().filter(cred -> cred.getUserHandle().equals((Object)userHandle)).findAny();
            return optional;
        }
        finally {
            readLock.unlock();
        }
    }

    protected Collection<CredentialRecord> getRegistrationsByUserHandle(ByteArray userHandle) {
        this.checkComponentActive();
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            HashSet<CredentialRecord> foundCredentials = new HashSet<CredentialRecord>();
            for (String usernameKey : this.storageService.getContextKeys(STORAGE_CONTEXT, null)) {
                assert (usernameKey != null);
                Set foundCredentialsForUser = (Set)((NonnullSupplier)this.getRegistrationsByUsername(usernameKey).stream().filter(cred -> userHandle.equals((Object)cred.getUserIdentity().getId())).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get();
                foundCredentials.addAll(foundCredentialsForUser);
            }
            HashSet<CredentialRecord> hashSet = foundCredentials;
            return hashSet;
        }
        catch (IOException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
        finally {
            readLock.unlock();
        }
    }

    @Nonnull
    public Set<RegisteredCredential> lookupAll(ByteArray credentialId) {
        this.checkComponentActive();
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            assert (credentialId != null);
            String usernameMapping = this.getUsernameFromCredentialIdCache(credentialId);
            Set registrations = usernameMapping != null ? (Set)((NonnullSupplier)this.getRegistrationsByUsername(usernameMapping).stream().filter(reg -> reg.getCredential().getCredentialId().equals((Object)credentialId)).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get() : this.getRegistrationsByCredentialId(credentialId);
            if (registrations.isEmpty()) {
                Set set = CollectionSupport.emptySet();
                return set;
            }
            List<String> usernames = registrations.stream().map(CredentialRecord::getUsername).distinct().toList();
            if (usernames.size() != 1) {
                throw new CredentialRepositoryException("CredentialId maps to more than one username, credential repository is inconsistent");
            }
            this.updateCredentialIdCache(registrations);
            Set set = (Set)((NonnullSupplier)registrations.stream().map(CredentialRecord::getCredential).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get();
            return set;
        }
        catch (Exception e) {
            throw new CredentialRepositoryException(e);
        }
        finally {
            readLock.unlock();
        }
    }

    @Nonnull
    @Unmodifiable
    protected Set<CredentialRecord> getRegistrationsByCredentialId(ByteArray credentialId) {
        this.checkComponentActive();
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            HashSet foundCredentials = new HashSet();
            for (String usernameKey : this.storageService.getContextKeys(STORAGE_CONTEXT, null)) {
                assert (usernameKey != null);
                Set foundCredentialsForUser = (Set)((NonnullSupplier)this.getRegistrationsByUsername(usernameKey).stream().filter(reg -> reg.getCredential().getCredentialId().equals((Object)credentialId)).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get();
                foundCredentials.addAll(foundCredentialsForUser);
            }
            Set set = CollectionSupport.copyToSet(foundCredentials);
            return set;
        }
        catch (IOException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
        finally {
            readLock.unlock();
        }
    }

    @Nonnull
    public Set<CredentialRecord> getRegistrationsByUsername(String username) {
        this.checkComponentActive();
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            StorageRecord registration = this.storageService.read(STORAGE_CONTEXT, username);
            if (registration != null) {
                Set credentials = (Set)registration.getValue(this.serializer, STORAGE_CONTEXT, username);
                if (!credentials.stream().allMatch(cr -> username.equals(cr.getUsername()))) {
                    throw new CredentialRepositoryException("Not all credentials match username, credential repository is inconsistent");
                }
                Set set = credentials;
                return set;
            }
            Set set = CollectionSupport.emptySet();
            return set;
        }
        catch (IOException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
        finally {
            readLock.unlock();
        }
    }

    @Nonnull
    private VersionedCredentialSet getRegistrationsByUsernameWithVersion(String username) {
        this.checkComponentActive();
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            StorageRecord registration = this.storageService.read(STORAGE_CONTEXT, username);
            if (registration != null) {
                Set credentials = (Set)registration.getValue(this.serializer, STORAGE_CONTEXT, username);
                if (!credentials.stream().allMatch(cr -> username.equals(cr.getUsername()))) {
                    throw new CredentialRepositoryException("Not all credentials match username, credential repository is inconsistent");
                }
                VersionedCredentialSet versionedCredentialSet = new VersionedCredentialSet(registration.getVersion(), credentials);
                return versionedCredentialSet;
            }
            VersionedCredentialSet versionedCredentialSet = new VersionedCredentialSet(0L, CollectionSupport.emptySet());
            return versionedCredentialSet;
        }
        catch (IOException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Optional<CredentialRecord> getRegistrationByUsernameAndCredentialId(String username, ByteArray id) {
        this.checkComponentActive();
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Set<CredentialRecord> existingRegistrations = this.getRegistrationsByUsername(username);
            Optional<CredentialRecord> registration = existingRegistrations.stream().filter(credReg -> id.equals((Object)credReg.getCredential().getCredentialId())).findFirst();
            assert (registration != null);
            Optional<CredentialRecord> optional = registration;
            return optional;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Optional<CredentialRecord> getRegistrationByUserHandleAndCredentialId(ByteArray credentialId, ByteArray userHandle) {
        this.checkComponentActive();
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Collection<CredentialRecord> existingRegistrations = this.getRegistrationsByUserHandle(userHandle);
            Optional<CredentialRecord> registration = existingRegistrations.stream().filter(credReg -> credentialId.equals((Object)credReg.getCredential().getCredentialId())).findFirst();
            assert (registration != null);
            Optional<CredentialRecord> optional = registration;
            return optional;
        }
        finally {
            readLock.unlock();
        }
    }

    public boolean addRegistrationByUsername(@Nonnull String username, @Nonnull CredentialRecord reg) {
        this.checkComponentActive();
        boolean registrationAdded = this.addRegistrationByUsernameImpl(username, reg);
        if (registrationAdded) {
            this.userHandleMappingCacheService.put(reg);
            this.credentialIdMappingCacheService.put(reg);
        }
        return registrationAdded;
    }

    private boolean addRegistrationByUsernameImpl(@Nonnull String username, @Nonnull CredentialRecord registration) {
        this.checkComponentActive();
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            VersionedCredentialSet existingRegistrations = this.getRegistrationsByUsernameWithVersion(username);
            if (!existingRegistrations.getCredentials().isEmpty()) {
                LinkedHashSet<CredentialRecord> updateSet = new LinkedHashSet<CredentialRecord>(existingRegistrations.getCredentials());
                updateSet.add(registration);
                Long updatedVersion = this.storageService.updateWithVersion(existingRegistrations.getVersion(), STORAGE_CONTEXT, username, updateSet, this.serializer, null);
                boolean bl = updatedVersion != null;
                return bl;
            }
            LinkedHashSet<CredentialRecord> addSet = new LinkedHashSet<CredentialRecord>(1);
            addSet.add(registration);
            boolean bl = this.storageService.create(STORAGE_CONTEXT, username, addSet, this.serializer, null);
            return bl;
        }
        catch (IOException | VersionMismatchException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean removeRegistrationByUsername(String username, CredentialRecord credentialRegistration) {
        this.checkComponentActive();
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            VersionedCredentialSet existingRegistrations = this.getRegistrationsByUsernameWithVersion(username);
            if (!existingRegistrations.getCredentials().isEmpty()) {
                LinkedHashSet<CredentialRecord> updateSet = new LinkedHashSet<CredentialRecord>(existingRegistrations.getCredentials());
                updateSet.remove(credentialRegistration);
                if (updateSet.isEmpty()) {
                    boolean bl = this.storageService.deleteWithVersion(existingRegistrations.getVersion(), STORAGE_CONTEXT, username);
                    return bl;
                }
                assert (this.serializer != null);
                Long updatedVersion = this.storageService.updateWithVersion(existingRegistrations.getVersion(), STORAGE_CONTEXT, username, updateSet, this.serializer, null);
                boolean bl = updatedVersion != null;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException | VersionMismatchException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
        finally {
            writeLock.unlock();
        }
    }

    public int removeRegistrationByCredentialId(ByteArray credentialId) {
        this.checkComponentActive();
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            int removalCount = 0;
            for (String usernameKey : this.storageService.getContextKeys(STORAGE_CONTEXT, null)) {
                assert (usernameKey != null);
                VersionedCredentialSet existingRegistrations = this.getRegistrationsByUsernameWithVersion(usernameKey);
                if (existingRegistrations.getCredentials().isEmpty()) {
                    this.log.trace("No existing registrations, nothing to remove");
                    continue;
                }
                List matchingRegistrations = (List)((NonnullSupplier)existingRegistrations.getCredentials().stream().filter(reg -> reg.getCredential().getCredentialId().equals((Object)credentialId)).collect(CollectionSupport.nonnullCollector(Collectors.toList()))).get();
                if (matchingRegistrations.size() != 1) continue;
                CredentialRecord registrationToRemove = (CredentialRecord)matchingRegistrations.get(0);
                LinkedHashSet<CredentialRecord> updateSet = new LinkedHashSet<CredentialRecord>(existingRegistrations.getCredentials());
                updateSet.remove(registrationToRemove);
                if (updateSet.isEmpty()) {
                    if (!this.storageService.deleteWithVersion(existingRegistrations.getVersion(), STORAGE_CONTEXT, usernameKey)) continue;
                    ++removalCount;
                    continue;
                }
                assert (this.serializer != null);
                if (this.storageService.updateWithVersion(existingRegistrations.getVersion(), STORAGE_CONTEXT, usernameKey, updateSet, this.serializer, null) == null) continue;
                ++removalCount;
            }
            int n = removalCount;
            return n;
        }
        catch (IOException | VersionMismatchException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean removeRegistrationByUsernameAndCredentialId(String username, ByteArray credentialId) {
        this.checkComponentActive();
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            VersionedCredentialSet existingRegistrations = this.getRegistrationsByUsernameWithVersion(username);
            if (!existingRegistrations.getCredentials().isEmpty()) {
                LinkedHashSet<CredentialRecord> updateSet = new LinkedHashSet<CredentialRecord>(existingRegistrations.getCredentials());
                List matchingRegistrations = (List)((NonnullSupplier)existingRegistrations.getCredentials().stream().filter(reg -> reg.getCredential().getCredentialId().equals((Object)credentialId)).collect(CollectionSupport.nonnullCollector(Collectors.toList()))).get();
                if (matchingRegistrations.size() != 1) {
                    boolean bl = false;
                    return bl;
                }
                updateSet.remove(matchingRegistrations.iterator().next());
                if (updateSet.isEmpty()) {
                    boolean bl = this.storageService.deleteWithVersion(existingRegistrations.getVersion(), STORAGE_CONTEXT, username);
                    return bl;
                }
                assert (this.serializer != null);
                Long updatedVersion = this.storageService.updateWithVersion(existingRegistrations.getVersion(), STORAGE_CONTEXT, username, updateSet, this.serializer, null);
                boolean bl = updatedVersion != null;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException | VersionMismatchException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSignatureCounter(@Nonnull String username, @Nonnull ByteArray credentialId, long newSignatureCount) {
        this.checkComponentActive();
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Optional<CredentialRecord> credential = this.getRegistrationByUsernameAndCredentialId(username, credentialId);
            if (credential.isEmpty()) {
                this.log.warn("Can not update signature count for user '{}' and credential '{}'. No existing credential found.", (Object)username, (Object)credentialId.getBase64());
                boolean bl = false;
                return bl;
            }
            if (newSignatureCount == 0L && credential.get().getCredential().getSignatureCount() == 0L) {
                this.log.trace("Authenticator does not implement a signature counter");
                boolean bl = true;
                return bl;
            }
        }
        finally {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            VersionedCredentialSet existingRegistrations = this.getRegistrationsByUsernameWithVersion(username);
            Optional<CredentialRecord> credential = existingRegistrations.getCredentials().stream().filter(credReg -> credentialId.equals((Object)credReg.getCredential().getCredentialId())).findFirst();
            if (credential.isEmpty()) {
                this.log.warn("Can not update signature count for user '{}' and credential '{}'. No existing credential found.", (Object)username, (Object)credentialId.getBase64());
                boolean bl = false;
                return bl;
            }
            RegisteredCredential updatedCredential = credential.get().getCredential().toBuilder().signatureCount(newSignatureCount).build();
            assert (updatedCredential != null);
            CredentialRecord updatedRegistration = credential.get().toBuilder().withCredential(updatedCredential).build();
            LinkedHashSet<CredentialRecord> updateCredentialSet = new LinkedHashSet<CredentialRecord>(existingRegistrations.getCredentials());
            updateCredentialSet.remove(credential.get());
            updateCredentialSet.add(updatedRegistration);
            if (updateCredentialSet.isEmpty()) {
                this.log.debug("Can not update signature count for user '{}' and credential '{}'. Update set is empty.", (Object)username, (Object)credentialId.getBase64());
                boolean bl = false;
                return bl;
            }
            Long updatedVersion = this.storageService.updateWithVersion(existingRegistrations.getVersion(), STORAGE_CONTEXT, username, updateCredentialSet, this.serializer, null);
            boolean bl = updatedVersion != null;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean updateLastUsedTime(@Nonnull String username, @Nonnull ByteArray credentialId, Instant lastUsedTime) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            VersionedCredentialSet existingRegistrations = this.getRegistrationsByUsernameWithVersion(username);
            Optional<CredentialRecord> credential = existingRegistrations.getCredentials().stream().filter(credReg -> credentialId.equals((Object)credReg.getCredential().getCredentialId())).findFirst();
            if (credential.isEmpty()) {
                this.log.warn("Can not update last used time for user '{}' and credential '{}'. No existing credential found.", (Object)username, (Object)credentialId.getBase64());
                boolean bl = false;
                return bl;
            }
            CredentialRecord updatedRegistration = credential.get().toBuilder().withLastUsedTime(lastUsedTime).build();
            LinkedHashSet<CredentialRecord> updateCredentialSet = new LinkedHashSet<CredentialRecord>(existingRegistrations.getCredentials());
            updateCredentialSet.remove(credential.get());
            updateCredentialSet.add(updatedRegistration);
            if (updateCredentialSet.isEmpty()) {
                this.log.debug("Can not last used time for user '{}' and credential '{}'. Update set is empty.", (Object)username, (Object)credentialId.getBase64());
                boolean bl = false;
                return bl;
            }
            Long updatedVersion = this.storageService.updateWithVersion(existingRegistrations.getVersion(), STORAGE_CONTEXT, username, updateCredentialSet, this.serializer, null);
            boolean bl = updatedVersion != null;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean updateNickname(@Nonnull String username, @Nonnull ByteArray credentialId, String nickname) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            VersionedCredentialSet existingRegistrations = this.getRegistrationsByUsernameWithVersion(username);
            Optional<CredentialRecord> credential = existingRegistrations.getCredentials().stream().filter(credReg -> credentialId.equals((Object)credReg.getCredential().getCredentialId())).findFirst();
            if (credential.isEmpty()) {
                this.log.debug("Cannot update nickname for user '{}' and credential '{}'. No existing credential found.", (Object)username, (Object)credentialId.getBase64());
                boolean bl = false;
                return bl;
            }
            CredentialRecord updatedRegistration = credential.get().toBuilder().withCredentialNickname(nickname).build();
            LinkedHashSet<CredentialRecord> updateCredentialSet = new LinkedHashSet<CredentialRecord>(existingRegistrations.getCredentials());
            updateCredentialSet.remove(credential.get());
            updateCredentialSet.add(updatedRegistration);
            if (updateCredentialSet.isEmpty()) {
                this.log.debug("Cannot update nickname for user '{}' and credential '{}'. Update set is empty.", (Object)username, (Object)credentialId.getBase64());
                boolean bl = false;
                return bl;
            }
            Long updatedVersion = this.storageService.updateWithVersion(existingRegistrations.getVersion(), STORAGE_CONTEXT, username, updateCredentialSet, this.serializer, null);
            boolean bl = updatedVersion != null;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<CredentialRecord> getAllRegistrations() {
        this.checkComponentActive();
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            HashSet allCredentials = new HashSet();
            for (String usernameKey : this.storageService.getContextKeys(STORAGE_CONTEXT, null)) {
                assert (usernameKey != null);
                allCredentials.addAll((Collection)((NonnullSupplier)this.getRegistrationsByUsername(usernameKey).stream().filter(Objects::nonNull).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get());
            }
            Set set = CollectionSupport.copyToSet(allCredentials);
            return set;
        }
        catch (IOException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
        finally {
            readLock.unlock();
        }
    }

    private class VersionedCredentialSet {
        private final long version;
        @Nonnull
        @Unmodifiable
        private final Set<CredentialRecord> credentials;

        public VersionedCredentialSet(@Nonnull long ver, Set<CredentialRecord> creds) {
            this.credentials = (Set)Constraint.isNotNull(creds, (String)"credential records can not be null");
            this.version = ver;
        }

        public long getVersion() {
            return this.version;
        }

        @Nonnull
        @Unmodifiable
        @NotLive
        public Set<CredentialRecord> getCredentials() {
            return CollectionSupport.copyToSet(this.credentials);
        }
    }
}

