/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.context;

import com.yubico.webauthn.data.AttestationConveyancePreference;
import com.yubico.webauthn.data.AuthenticatorAttachment;
import com.yubico.webauthn.data.AuthenticatorAttestationResponse;
import com.yubico.webauthn.data.ClientRegistrationExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialCreationOptions;
import com.yubico.webauthn.data.ResidentKeyRequirement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.plugin.authn.webauthn.admin.RegistrationResult;
import net.shibboleth.idp.plugin.authn.webauthn.context.BaseWebAuthnContext;

@NotThreadSafe
public final class WebAuthnRegistrationContext
extends BaseWebAuthnContext {
    @Nullable
    private String name;
    @Nullable
    private PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> publicKeyCredentialAttestationResponse;
    @Nullable
    private PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions;
    @Nullable
    private RegistrationResult registrationResult;
    @Nullable
    private String credentialNickname;
    @Nullable
    private byte[] credentialIdToRemove;
    @Nullable
    private ResidentKeyRequirement residentKeyRequirement;
    @Nullable
    private AuthenticatorAttachment authenticatorAttachmentRequirement;
    @Nullable
    private AttestationConveyancePreference attestationConveyancePreference;
    @Nullable
    private String displayName;
    private boolean nicknameRequired;
    @Nullable
    private byte[] credentialIdToModify;

    public boolean isNicknameRequired() {
        return this.nicknameRequired;
    }

    public BaseWebAuthnContext setNicknameRequired(boolean flag) {
        this.nicknameRequired = flag;
        return this;
    }

    @Nonnull
    public BaseWebAuthnContext setName(@Nullable String webAuthnName) {
        this.name = webAuthnName;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public WebAuthnRegistrationContext setAuthenticatorAttachmentRequirement(@Nullable AuthenticatorAttachment requirement) {
        this.authenticatorAttachmentRequirement = requirement;
        return this;
    }

    public AuthenticatorAttachment getAuthenticatorAttachmentRequirement() {
        return this.authenticatorAttachmentRequirement;
    }

    @Nullable
    public PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> getPublicKeyCredentialAttestationResponse() {
        return this.publicKeyCredentialAttestationResponse;
    }

    @Nonnull
    public WebAuthnRegistrationContext setPublicKeyCredentialAttestationResponse(@Nullable PublicKeyCredential<AuthenticatorAttestationResponse, ClientRegistrationExtensionOutputs> pkCredAttestation) {
        this.publicKeyCredentialAttestationResponse = pkCredAttestation;
        return this;
    }

    @Nonnull
    public WebAuthnRegistrationContext setPublicKeyCredentialCreationOptions(@Nullable PublicKeyCredentialCreationOptions options) {
        this.publicKeyCredentialCreationOptions = options;
        return this;
    }

    @Nullable
    public PublicKeyCredentialCreationOptions getPublicKeyCredentialCreationOptions() {
        return this.publicKeyCredentialCreationOptions;
    }

    @Nonnull
    public WebAuthnRegistrationContext setRegistrationResult(@Nullable RegistrationResult result) {
        this.registrationResult = result;
        return this;
    }

    @Nullable
    public RegistrationResult getRegistrationResult() {
        return this.registrationResult;
    }

    @Nonnull
    public WebAuthnRegistrationContext setCredentialNickname(@Nullable String nickname) {
        this.credentialNickname = nickname;
        return this;
    }

    @Nullable
    public String getCredentialNickname() {
        return this.credentialNickname;
    }

    @Deprecated(since="1.2.0", forRemoval=true)
    @Nonnull
    public WebAuthnRegistrationContext setCredentialIdToRemove(@Nullable byte[] id) {
        this.credentialIdToRemove = id;
        return this;
    }

    @Nullable
    public byte[] getCredentialIdToRemove() {
        return this.credentialIdToRemove;
    }

    @Nonnull
    public WebAuthnRegistrationContext setResidentKeyRequirement(@Nullable ResidentKeyRequirement requirement) {
        this.residentKeyRequirement = requirement;
        return this;
    }

    @Nullable
    public ResidentKeyRequirement getResidentKeyRequirement() {
        return this.residentKeyRequirement;
    }

    @Nonnull
    public BaseWebAuthnContext setAttestationConveyancePreference(@Nullable AttestationConveyancePreference preference) {
        this.attestationConveyancePreference = preference;
        return this;
    }

    @Nullable
    public AttestationConveyancePreference getAttestationConveyancePreference() {
        return this.attestationConveyancePreference;
    }

    @Nonnull
    public BaseWebAuthnContext setDisplayName(@Nullable String dispName) {
        this.displayName = dispName;
        return this;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Nonnull
    public WebAuthnRegistrationContext setCredentialIdToModify(@Nullable byte[] id) {
        this.credentialIdToModify = id;
        return this;
    }

    @Nullable
    public byte[] getCredentialIdToModify() {
        return this.credentialIdToModify;
    }
}

