/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.storage.impl;

import com.yubico.webauthn.data.ByteArray;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.webauthn.exception.CredentialRepositoryException;
import net.shibboleth.idp.plugin.authn.webauthn.storage.CredentialRecord;
import net.shibboleth.idp.plugin.authn.webauthn.storage.impl.WebAuthnJDBCQueryAccelerator;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.storage.StorageRecord;

public class QueryByCredentialIdStrategy
implements BiFunction<String, ByteArray, List<StorageRecord<Set<CredentialRecord>>>> {
    @Nonnull
    private final WebAuthnJDBCQueryAccelerator queryAccelerator;

    public QueryByCredentialIdStrategy(@Nonnull WebAuthnJDBCQueryAccelerator accelerator) {
        this.queryAccelerator = (WebAuthnJDBCQueryAccelerator)Constraint.isNotNull((Object)accelerator, (String)"Accelerator can not be empty");
    }

    @Override
    public List<StorageRecord<Set<CredentialRecord>>> apply(String storageContext, ByteArray credentialId) {
        if (storageContext == null || credentialId == null) {
            throw new CredentialRepositoryException("Query parameters can not be null");
        }
        String credentialIdB64 = credentialId.getBase64Url();
        try {
            return this.queryAccelerator.queryByCredentialId(storageContext, credentialIdB64);
        }
        catch (IOException e) {
            throw new CredentialRepositoryException((Exception)e);
        }
    }
}

