/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.impl;

import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialRequestOptions;
import java.security.Principal;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.impl.AbstractAuditingValidationAction;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.plugin.authn.webauthn.authn.AssertionResult;
import net.shibboleth.idp.plugin.authn.webauthn.client.WebAuthnAuthenticationClient;
import net.shibboleth.idp.plugin.authn.webauthn.context.WebAuthnAuthenticationContext;
import net.shibboleth.idp.plugin.authn.webauthn.exception.AssertionFailureException;
import net.shibboleth.idp.plugin.authn.webauthn.exception.CredentialRepositoryException;
import net.shibboleth.idp.plugin.authn.webauthn.principal.WebAuthnUserIdPrinicpal;
import net.shibboleth.idp.plugin.authn.webauthn.storage.WebAuthnCredentialRepository;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateWebAuthnAssertion
extends AbstractAuditingValidationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateWebAuthnAssertion.class);
    @Nonnull
    private final Function<ProfileRequestContext, WebAuthnAuthenticationContext> webauthnContextLookupStrategy = new ChildContextLookup(WebAuthnAuthenticationContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @NonnullBeforeExec
    private WebAuthnAuthenticationContext context;
    @NonnullAfterInit
    private WebAuthnAuthenticationClient webAuthnClient;
    @NonnullAfterInit
    private WebAuthnCredentialRepository credentialRepository;
    @NonnullBeforeExec
    private PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions;
    @Nonnull
    private Predicate<ProfileRequestContext> updateSignatureCount = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> updateLastUsedTime = PredicateSupport.alwaysFalse();

    protected void doInitialize() throws ComponentInitializationException {
        if (this.webAuthnClient == null) {
            throw new ComponentInitializationException("WebAuthn client can not be null. Configuration error.");
        }
        if (this.credentialRepository == null) {
            throw new ComponentInitializationException("CredentialRepository can not be null");
        }
        super.doInitialize();
    }

    public void setCredentialRepository(@Nonnull WebAuthnCredentialRepository repository) {
        this.checkSetterPreconditions();
        this.credentialRepository = (WebAuthnCredentialRepository)Constraint.isNotNull((Object)repository, (String)"Credential respository can not be null");
    }

    public void setWebAuthnClient(@Nonnull WebAuthnAuthenticationClient client) {
        this.checkSetterPreconditions();
        this.webAuthnClient = (WebAuthnAuthenticationClient)Constraint.isNotNull((Object)client, (String)"WebAuthn client can not be null");
    }

    public void setUpdateSignatureCount(boolean flag) {
        this.checkSetterPreconditions();
        this.updateSignatureCount = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setUpdateSignatureCountPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        this.updateSignatureCount = (Predicate)Constraint.isNotNull(predicate, (String)"updateSignatureCount predicate can not be null");
    }

    public void setUpdateLastUsedTimePredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        this.updateLastUsedTime = (Predicate)Constraint.isNotNull(predicate, (String)"updateLastUsedTime can not be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        this.context = this.webauthnContextLookupStrategy.apply(profileRequestContext);
        if (this.context == null) {
            this.log.warn("{} No WebAuthn context returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        this.publicKeyCredentialRequestOptions = this.context.getPublicKeyCredentialRequestOptions();
        if (this.publicKeyCredentialRequestOptions == null) {
            this.log.warn("{} No public key credential request options in context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        PublicKeyCredential assertion = this.context.getPublicKeyCredentialAssertionResponse();
        if (assertion == null) {
            this.log.warn("{} No PublicKeyCredential with authenticator assertion found, can not authenticate '{}'", (Object)this.getLogPrefix(), (Object)this.context.getUsername());
            this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            this.recordFailure(profileRequestContext);
            return;
        }
        try {
            PublicKeyCredentialRequestOptions localPublicKeyCredentialRequestOptions = this.publicKeyCredentialRequestOptions;
            assert (localPublicKeyCredentialRequestOptions != null);
            AssertionResult result = this.webAuthnClient.validateAuthenticatorAssertionResponse(this.context.getUsername(), this.context.getUserId(), localPublicKeyCredentialRequestOptions, assertion);
            if (!result.isSuccess()) {
                throw new AssertionFailureException("Assertion was not valid");
            }
            if (!result.isSignatureCounterValid()) {
                throw new AssertionFailureException("Assertion was not valid, signature count is invalid");
            }
            if (this.updateSignatureCount.test(profileRequestContext)) {
                this.updateSignatureCount(result.getUsername(), (PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs>)assertion);
            }
            if (this.updateLastUsedTime.test(profileRequestContext)) {
                this.updateLastUsedTime(result.getUsername(), (PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs>)assertion);
            }
            this.log.info("{} WebAuthn authentication succeeded for '{}', authenticator verified the user '{}'", new Object[]{this.getLogPrefix(), result.getUsername(), result.isUserVerified()});
            this.context.setUsername(result.getUsername());
            this.context.setUserId(result.getUserId());
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
            this.recordSuccess(profileRequestContext);
        }
        catch (AssertionFailureException e) {
            this.log.warn("{} Error validating authenticator assertion for '{}'", new Object[]{this.getLogPrefix(), this.context.getUsername() != null ? this.context.getUsername() : "unknown user", e});
            this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            this.recordFailure(profileRequestContext);
            return;
        }
    }

    private void updateLastUsedTime(@Nonnull String username, @Nonnull PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> assertion) throws AssertionFailureException {
        ByteArray credentialId = assertion.getId();
        if (credentialId == null) {
            this.log.debug("{} Failed to updated last used time of credential for user '{}'; no credentialId in assertion", (Object)this.getLogPrefix(), (Object)username);
            return;
        }
        try {
            if (!this.credentialRepository.updateLastUsedTime(username, credentialId, Instant.now())) {
                this.log.debug("{} Failed to updated last used time of credential '{}' for user '{}'", new Object[]{this.getLogPrefix(), credentialId.getBase64(), username});
            } else {
                this.log.trace("{} Updated credential last used time for credential '{}' and user '{}'", new Object[]{this.getLogPrefix(), credentialId.getBase64(), username});
            }
        }
        catch (CredentialRepositoryException e) {
            this.log.debug("{} Failed to updated last used time of credential '{}' for user '{}'", new Object[]{this.getLogPrefix(), credentialId.getBase64(), username, e});
        }
    }

    private void updateSignatureCount(@Nonnull String username, @Nonnull PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> assertion) throws AssertionFailureException {
        ByteArray credentialId = assertion.getId();
        if (credentialId == null) {
            throw new AssertionFailureException("Can not update signature count for user '" + username + "' and credential '" + String.valueOf(assertion.getId()) + "'. Assertion goes not contain the credential Id.");
        }
        long newSignatureCount = ((AuthenticatorAssertionResponse)assertion.getResponse()).getParsedAuthenticatorData().getSignatureCounter();
        try {
            if (!this.credentialRepository.updateSignatureCounter(username, credentialId, newSignatureCount)) {
                throw new AssertionFailureException("Failed to update signature counter");
            }
        }
        catch (CredentialRepositoryException e) {
            throw new AssertionFailureException((Throwable)e);
        }
    }

    protected void buildAuthenticationResult(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        super.buildAuthenticationResult(profileRequestContext, authenticationContext);
        ((SubjectCanonicalizationContext)profileRequestContext.ensureSubcontext(SubjectCanonicalizationContext.class)).setPrincipalName(this.context.getUsername());
    }

    protected Subject populateSubject(@Nonnull Subject subject) {
        byte[] userId = this.context.getUserId();
        if (userId != null) {
            subject.getPrincipals().add((Principal)new WebAuthnUserIdPrinicpal(userId));
        }
        if (this.context.isSecondFactor() && subject.getPrincipals(UsernamePrincipal.class) != null) {
            this.log.trace("{} second factor usage, username principal already set", (Object)this.getLogPrefix());
            return subject;
        }
        String username = this.context.getUsername();
        assert (username != null);
        subject.getPrincipals().add((Principal)new UsernamePrincipal(username));
        return subject;
    }

    public static class WebAuthnCleanupHook
    implements Consumer<ProfileRequestContext> {
        @Override
        public void accept(ProfileRequestContext input) {
            AuthenticationContext authnCtx;
            AuthenticationContext authenticationContext = authnCtx = input != null ? (AuthenticationContext)input.getSubcontext(AuthenticationContext.class) : null;
            if (authnCtx == null) {
                return;
            }
            WebAuthnAuthenticationContext webAuthnCtx = (WebAuthnAuthenticationContext)authnCtx.getSubcontext(WebAuthnAuthenticationContext.class);
            if (webAuthnCtx == null) {
                return;
            }
            authnCtx.removeSubcontext((BaseContext)webAuthnCtx);
        }
    }
}

