/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.impl;

import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialRequestOptions;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.webauthn.context.WebAuthnAuthenticationContext;
import net.shibboleth.idp.plugin.authn.webauthn.impl.AbstractWebAuthnAction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class CheckUserHandleExistsIfNoAllowCredentials
extends AbstractWebAuthnAction<WebAuthnAuthenticationContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CheckUserHandleExistsIfNoAllowCredentials.class);
    private PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> assertion;
    private PublicKeyCredentialRequestOptions requestOptions;

    protected CheckUserHandleExistsIfNoAllowCredentials() {
        super(new ChildContextLookup(WebAuthnAuthenticationContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class)));
    }

    @Override
    protected boolean doPreExecute(ProfileRequestContext profileRequestContext, WebAuthnAuthenticationContext context) {
        this.assertion = context.getPublicKeyCredentialAssertionResponse();
        if (this.assertion == null) {
            this.log.error("{} Unable to find Assertion in WebAuthn authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.requestOptions = context.getPublicKeyCredentialRequestOptions();
        if (this.requestOptions == null) {
            this.log.error("{} Unable to find credential request options in WebAuthn authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull WebAuthnAuthenticationContext context) {
        boolean allowedCredentialsRequested;
        Optional allowCredentials = this.requestOptions.getAllowCredentials();
        Optional userHandle = ((AuthenticatorAssertionResponse)this.assertion.getResponse()).getUserHandle();
        boolean bl = allowedCredentialsRequested = allowCredentials.isPresent() && !((List)allowCredentials.get()).isEmpty();
        if (allowedCredentialsRequested && context.getExistingCredentials().isEmpty()) {
            this.log.error("{} Credentials were requested but none exist in the context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return;
        }
        if (allowCredentials.isEmpty() || allowCredentials.get() == null || ((List)allowCredentials.get()).isEmpty()) {
            if (userHandle.isEmpty()) {
                this.log.debug("{} Allow credentials is empty and the userHandle was not returned in the response, the userHandle is required", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
                return;
            }
            this.log.trace("{} Allow credentials is empty and the userHandle was returned in the response", (Object)this.getLogPrefix());
        } else {
            this.log.trace("{} Allow credentials is not empty and the (optional) userHandle was {}", (Object)this.getLogPrefix(), (Object)(userHandle.isPresent() ? "returned in the response" : "not returned in the response"));
        }
    }
}

