/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.admin.impl;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.plugin.authn.webauthn.context.WebAuthnGuardContext;
import net.shibboleth.idp.plugin.authn.webauthn.storage.WebAuthnCredentialRepository;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class RequireStrongFreshAuthnAccessPredicate
extends AbstractIdentifiableInitializableComponent
implements Predicate<ProfileRequestContext> {
    @Nonnull
    @NotEmpty
    private final Logger log = LoggerFactory.getLogger(RequireStrongFreshAuthnAccessPredicate.class);
    @Nonnull
    private Function<ProfileRequestContext, WebAuthnGuardContext> webAuthnGuardContextLookupStrategy = new ChildContextLookup(WebAuthnGuardContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> subjectContextLookupStrategy = new ChildContextLookup(SubjectContext.class);
    @NonnullAfterInit
    private WebAuthnCredentialRepository credentialRepository;

    public void setWebAuthnGuardContextLookupStrategy(Function<ProfileRequestContext, WebAuthnGuardContext> strategy) {
        this.checkSetterPreconditions();
        this.webAuthnGuardContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"WebAuthnGuardContextLookupStrategy can not be null");
    }

    public void setSubjectContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        this.checkSetterPreconditions();
        this.subjectContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext lookup strategy cannot be null");
    }

    public void setCredentialRepository(@Nonnull WebAuthnCredentialRepository repository) {
        this.checkSetterPreconditions();
        this.credentialRepository = (WebAuthnCredentialRepository)Constraint.isNotNull((Object)repository, (String)"Credential respository can not be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.credentialRepository == null) {
            throw new ComponentInitializationException("Credential respository can not be null");
        }
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext profileRequestContext) {
        if (profileRequestContext == null) {
            this.log.debug("ProfileRequestContext is not available, access control predicate can not run, denying access");
            return false;
        }
        WebAuthnGuardContext guardContext = this.webAuthnGuardContextLookupStrategy.apply(profileRequestContext);
        SubjectContext subjectContext = this.subjectContextLookupStrategy.apply(profileRequestContext);
        if (subjectContext == null) {
            this.log.debug("{}: No subject context found, access requires authentication.", (Object)this.getId());
            return false;
        }
        String usernameFromSubjectContext = subjectContext.getPrincipalName();
        if (StringSupport.trimOrNull((String)usernameFromSubjectContext) == null) {
            this.log.debug("{}: No principal name found in subject context, denying access", (Object)this.getId());
            return false;
        }
        this.log.trace("{}: Username (principal name) from subject context '{}'", (Object)this.getId(), (Object)usernameFromSubjectContext);
        if (guardContext == null) {
            this.log.debug("{}: WebAuthnGuardContext not found, suggests the authentication is not fresh or the guard context was not initialised, denying access", (Object)this.getId());
            return false;
        }
        assert (usernameFromSubjectContext != null);
        Set credentials = this.credentialRepository.getRegistrationsByUsername(usernameFromSubjectContext);
        boolean hasCredentials = !credentials.isEmpty();
        boolean isStronglyAuthenticated = guardContext.isStronglyAuthenticated();
        this.log.debug("{}: Does user '{}' have FIDO2 credentials '{}', did they strongly authenticate '{}'", new Object[]{this.getId(), usernameFromSubjectContext, hasCredentials ? "yes" : "no", isStronglyAuthenticated ? "yes" : "no"});
        if (hasCredentials && !isStronglyAuthenticated) {
            this.log.info("{}: User '{}' has FIDO2 credentials but did not strongly authenticate, denying access", (Object)this.getId(), (Object)usernameFromSubjectContext);
            return false;
        }
        return true;
    }
}

