/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.totp.impl;

import com.google.common.net.UrlEscapers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLine;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLineArguments;
import net.shibboleth.idp.plugin.authn.totp.impl.TOTPAuthenticator;
import net.shibboleth.idp.plugin.authn.totp.impl.TOTPAuthenticatorArguments;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base32Support;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class TOTPAuthenticatorCLI
extends AbstractIdPHomeAwareCommandLine<TOTPAuthenticatorArguments> {
    @Nullable
    private Logger log;

    @Nonnull
    protected Logger getLogger() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(TOTPAuthenticatorCLI.class);
        }
        assert (this.log != null);
        return this.log;
    }

    @Nonnull
    protected Class<TOTPAuthenticatorArguments> getArgumentClass() {
        return TOTPAuthenticatorArguments.class;
    }

    @Nonnull
    @NotEmpty
    protected String getVersion() {
        return ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
    }

    protected int doRun(@Nonnull TOTPAuthenticatorArguments args) {
        int ret = super.doRun((AbstractIdPHomeAwareCommandLineArguments)args);
        if (ret != 0) {
            return ret;
        }
        try {
            String authenticatorName = args.getAuthenticatorName();
            TOTPAuthenticator authenticator = authenticatorName != null ? (TOTPAuthenticator)this.getApplicationContext().getBean(authenticatorName, TOTPAuthenticator.class) : (TOTPAuthenticator)this.getApplicationContext().getBean(TOTPAuthenticator.class);
            byte[] seed = args.getSeed();
            Integer tokenCode = args.getTokenCode();
            if (seed != null && tokenCode != null) {
                if (authenticator.validate(seed, tokenCode)) {
                    System.out.println("OK");
                    return 0;
                }
                System.out.println("INVALID");
                return -1;
            }
            TOTPAuthenticator.TOTPCredential tc = authenticator.createCredential(args.getIssuer(), args.getAccountName());
            System.out.println("Seed: " + Base32Support.encode((byte[])tc.getKey(), (boolean)false));
            System.out.println("URL: " + tc.getTOTPURL());
            System.out.println("QR Code: https://api.qrserver.com/v1/create-qr-code/?data=" + UrlEscapers.urlFormParameterEscaper().escape(tc.getTOTPURL()) + "&size=200x200&ecc=M&margin=0");
        }
        catch (Exception e) {
            if (args.isVerboseOutput()) {
                this.getLogger().error("Unable to access TOTPAuthenticator from Spring context", (Throwable)e);
            } else {
                this.getLogger().error("Unable to access TOTPAuthenticator from Spring context", (Object)e.getMessage());
            }
            return -1;
        }
        return 0;
    }

    public static void main(@Nonnull String[] args) {
        System.exit(new TOTPAuthenticatorCLI().run(args));
    }
}

