/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.totp.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.AuthenticationErrorContext;
import net.shibboleth.idp.plugin.authn.totp.context.TOTPContext;
import net.shibboleth.idp.session.context.navigate.CanonicalUsernameLookupStrategy;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractTOTPExtractionAction
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractTOTPExtractionAction.class);
    @Nonnull
    private Function<ProfileRequestContext, String> usernameLookupStrategy = new CanonicalUsernameLookupStrategy();
    @Nonnull
    private Function<AuthenticationContext, TOTPContext> totpContextCreationStrategy = new ChildContextLookup(TOTPContext.class, true);

    public void setUsernameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.usernameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Username lookup strategy cannot be null");
    }

    public void setTOTPContextCreationStrategy(@Nonnull Function<AuthenticationContext, TOTPContext> strategy) {
        this.checkSetterPreconditions();
        this.totpContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"TOTPContext creation strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        HttpServletRequest request;
        authenticationContext.removeSubcontext(AuthenticationErrorContext.class);
        TOTPContext totpContext = this.totpContextCreationStrategy.apply(authenticationContext);
        if (totpContext == null) {
            this.log.warn("{} Unable to create TOTP context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        totpContext.setTokenCode(null);
        if (totpContext.getUsername() == null) {
            String username = this.usernameLookupStrategy.apply(profileRequestContext);
            if (username == null) {
                this.log.warn("{} No principal name available", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnknownUsername");
                return;
            }
            totpContext.setUsername(username);
        }
        if ((request = this.getHttpServletRequest()) == null) {
            this.log.debug("{} Profile action does not contain an HttpServletRequest", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        String code = this.extractCode(request);
        if (code == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        try {
            totpContext.setTokenCode(Integer.valueOf(code));
        }
        catch (NumberFormatException e) {
            this.log.warn("{} Exception converting code string to an integer", (Object)this.getLogPrefix(), (Object)e);
            ((AuthenticationErrorContext)authenticationContext.ensureSubcontext(AuthenticationErrorContext.class)).getClassifiedErrors().add("InvalidCredentials");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
        }
    }

    @Nullable
    protected abstract String extractCode(@Nonnull HttpServletRequest var1);
}

