/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.totp.impl;

import java.security.Principal;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractCredentialValidator;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.principal.TOTPPrincipal;
import net.shibboleth.idp.plugin.authn.totp.context.TOTPContext;
import net.shibboleth.idp.plugin.authn.totp.impl.TOTPAuthenticator;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class TOTPCredentialValidator
extends AbstractCredentialValidator {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.totp";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TOTPCredentialValidator.class);
    @Nonnull
    private Function<AuthenticationContext, TOTPContext> totpContextLookupStrategy = new ChildContextLookup(TOTPContext.class);
    @NonnullAfterInit
    private TOTPAuthenticator authenticator;
    @NonnullAfterInit
    private Consumer<ProfileRequestContext> seedSource;
    @Nullable
    private Pattern matchExpression;

    public void setTOTPContextLookupStrategy(@Nonnull Function<AuthenticationContext, TOTPContext> strategy) {
        this.checkSetterPreconditions();
        this.totpContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TOTPContext lookup strategy cannot be null");
    }

    public void setAuthenticator(@Nonnull TOTPAuthenticator impl) {
        this.checkSetterPreconditions();
        this.authenticator = (TOTPAuthenticator)Constraint.isNotNull((Object)impl, (String)"TOTPAuthenticator cannot be null");
    }

    public void setSeedSource(@Nonnull Consumer<ProfileRequestContext> source) {
        this.checkSetterPreconditions();
        this.seedSource = (Consumer)Constraint.isNotNull(source, (String)"Token seed source cannot be null");
    }

    public void setMatchExpression(@Nullable Pattern expression) {
        this.checkSetterPreconditions();
        this.matchExpression = expression;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.seedSource == null) {
            throw new ComponentInitializationException("Token seed source cannot be null");
        }
    }

    protected Subject doValidate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        TOTPContext totpContext = this.totpContextLookupStrategy.apply(authenticationContext);
        if (totpContext == null) {
            this.log.info("{} No TOTPContext available", (Object)this.getLogPrefix());
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            }
            throw new LoginException("NoCredentials");
        }
        if (totpContext.getUsername() == null) {
            this.log.info("{} No username available within TOTPContext", (Object)this.getLogPrefix());
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, "UnknownUsername", "UnknownUsername");
            }
            throw new LoginException("NoCredentials");
        }
        if (totpContext.getTokenCode() == null) {
            this.log.info("{} No tokencode available within TOTPContext", (Object)this.getLogPrefix());
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            }
            throw new LoginException("NoCredentials");
        }
        if (totpContext.getTokenSeeds().isEmpty()) {
            this.seedSource.accept(profileRequestContext);
            if (totpContext.getTokenSeeds().isEmpty()) {
                this.log.info("{} No seeds were obtained for user '{}'", (Object)this.getLogPrefix(), (Object)totpContext.getUsername());
                if (errorHandler != null) {
                    errorHandler.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
                }
                throw new LoginException("InvalidCredentials");
            }
        }
        if (this.matchExpression != null && !this.matchExpression.matcher(totpContext.getUsername()).matches()) {
            this.log.debug("{} Username '{}' did not match expression", (Object)this.getLogPrefix(), (Object)totpContext.getUsername());
            return null;
        }
        this.log.debug("{} Attempting to authenticate token code for '{}' ", (Object)this.getLogPrefix(), (Object)totpContext.getUsername());
        try {
            Integer tokenCode = totpContext.getTokenCode();
            assert (tokenCode != null);
            if (totpContext.getTokenSeeds().stream().anyMatch(seed -> this.authenticator.validate((byte[])seed, tokenCode))) {
                this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)totpContext.getUsername());
                return this.populateSubject(new Subject(), profileRequestContext, totpContext);
            }
            throw new LoginException("InvalidCredentials");
        }
        catch (Exception e) {
            this.log.info("{} Login by '{}' failed", new Object[]{this.getLogPrefix(), totpContext.getUsername(), e});
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, e, "InvalidCredentials");
            }
            throw e;
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull TOTPContext totpContext) {
        String username = totpContext.getUsername();
        assert (username != null);
        subject.getPrincipals().add((Principal)new TOTPPrincipal(username));
        ((SubjectCanonicalizationContext)profileRequestContext.ensureSubcontext(SubjectCanonicalizationContext.class)).setPrincipalName(totpContext.getUsername());
        return super.populateSubject(subject);
    }
}

