/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.totp.impl;

import com.google.common.net.UrlEscapers;
import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorConfig;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import java.security.GeneralSecurityException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.totp.impl.TOTPAuthenticator;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.codec.Base32Support;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

@ThreadSafeAfterInit
public class GoogleTOTPAuthenticator
extends AbstractInitializableComponent
implements TOTPAuthenticator {
    @NonnullAfterInit
    private GoogleAuthenticatorConfig authconfig;
    @NonnullAfterInit
    private GoogleAuthenticator authenticator;

    public void setGoogleAuthenticatorConfig(@Nonnull GoogleAuthenticatorConfig config) {
        this.checkSetterPreconditions();
        this.authconfig = (GoogleAuthenticatorConfig)Constraint.isNotNull((Object)config, (String)"GoogleAuthenticator cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.authconfig == null) {
            this.authconfig = new GoogleAuthenticatorConfig();
        }
        this.authenticator = new GoogleAuthenticator(this.authconfig);
    }

    @Override
    @Nonnull
    public TOTPAuthenticator.TOTPCredential createCredential(@Nullable @NotEmpty String issuer, @Nullable @NotEmpty String accountName) throws GeneralSecurityException {
        GoogleAuthenticatorKey cred = this.authenticator.createCredentials();
        final String trimmedIssuer = StringSupport.trimOrNull((String)issuer);
        final String trimmedName = StringSupport.trimOrNull((String)accountName);
        try {
            byte[] secret;
            return new TOTPAuthenticator.TOTPCredential(){
                final /* synthetic */ String val$encodedSecret;
                final /* synthetic */ String val$issuer;
                final /* synthetic */ GoogleAuthenticatorKey val$cred;
                {
                    this.val$encodedSecret = string3;
                    this.val$issuer = string4;
                    this.val$cred = googleAuthenticatorKey;
                }

                @Override
                @Nonnull
                public byte[] getKey() {
                    return secret;
                }

                @Override
                @Nonnull
                public String getTOTPURL() {
                    Object label = trimmedName != null ? (trimmedIssuer != null ? trimmedIssuer + ":" + trimmedName : trimmedName) : null;
                    StringBuilder url = new StringBuilder();
                    url.append("otpauth://totp/").append(UrlEscapers.urlPathSegmentEscaper().escape((String)label)).append("?secret=").append(UrlEscapers.urlFormParameterEscaper().escape(this.val$encodedSecret));
                    if (trimmedIssuer != null) {
                        url.append("&issuer=").append(UrlEscapers.urlFormParameterEscaper().escape(this.val$issuer));
                    }
                    return url.toString();
                }

                @Override
                @Nonnull
                public Collection<Integer> getScratchCodes() {
                    return this.val$cred.getScratchCodes();
                }
            };
        }
        catch (DecodingException | EncodingException e) {
            throw new GeneralSecurityException(e);
        }
    }

    @Override
    public boolean validate(@Nonnull @NotEmpty byte[] secret, int code) {
        String encodedSecret;
        try {
            switch (this.authconfig.getKeyRepresentation()) {
                case BASE32: {
                    encodedSecret = Base32Support.encode((byte[])secret, (boolean)false);
                    break;
                }
                case BASE64: {
                    encodedSecret = Base64Support.encode((byte[])secret, (boolean)false);
                    break;
                }
                default: {
                    throw new EncodingException("Unknown key representation type");
                }
            }
        }
        catch (EncodingException e) {
            return false;
        }
        return this.authenticator.authorize(encodedSecret, code);
    }
}

