/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.principal;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.principal.CloneablePrincipal;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class OIDCSubjectIdentifierPrincipal
implements CloneablePrincipal {
    @Nonnull
    @NotEmpty
    private String subject;

    public OIDCSubjectIdentifierPrincipal(@Nonnull @ParameterName(name="name") @NotEmpty String sub) {
        this.subject = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sub), (String)"Subject cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getName() {
        return this.subject;
    }

    public int hashCode() {
        return this.subject.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof OIDCSubjectIdentifierPrincipal) {
            OIDCSubjectIdentifierPrincipal principal = (OIDCSubjectIdentifierPrincipal)other;
            return this.subject.equals(principal.getName());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("subject", (Object)this.subject).toString();
    }

    public OIDCSubjectIdentifierPrincipal clone() throws CloneNotSupportedException {
        OIDCSubjectIdentifierPrincipal copy = (OIDCSubjectIdentifierPrincipal)super.clone();
        copy.subject = this.subject;
        return copy;
    }
}

