/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.principal;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.principal.CloneablePrincipal;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class OAuth2RefreshTokenPrincipal
implements CloneablePrincipal {
    @Nonnull
    @NotEmpty
    private String refreshToken;

    public OAuth2RefreshTokenPrincipal(@Nonnull @ParameterName(name="refreshToken") @NotEmpty String token) {
        this.refreshToken = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)token), (String)"Refresh Token cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getName() {
        return this.refreshToken;
    }

    public int hashCode() {
        return this.refreshToken.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof OAuth2RefreshTokenPrincipal) {
            OAuth2RefreshTokenPrincipal principal = (OAuth2RefreshTokenPrincipal)other;
            return this.refreshToken.equals(principal.getName());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("refresh_token", (Object)this.refreshToken).toString();
    }

    public OAuth2RefreshTokenPrincipal clone() throws CloneNotSupportedException {
        OAuth2RefreshTokenPrincipal copy = (OAuth2RefreshTokenPrincipal)super.clone();
        copy.refreshToken = this.refreshToken;
        return copy;
    }
}

