/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.principal;

import com.google.common.base.MoreObjects;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.principal.CloneablePrincipal;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class OAuth2AccessTokenPrincipal
implements CloneablePrincipal {
    @Nonnull
    @NotEmpty
    private String accessToken;
    @Nonnull
    @NotEmpty
    private String accessTokenType;
    @Nullable
    private Duration expiresIn;

    public OAuth2AccessTokenPrincipal(@Nonnull @ParameterName(name="accessToken") @NotEmpty String token, @Nonnull @ParameterName(name="accessToken") @NotEmpty String tokenType, @Nullable @ParameterName(name="expiresIn") Duration expiresInDuration) {
        this.accessToken = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)token), (String)"Access Token cannot be null or empty");
        this.accessTokenType = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)tokenType), (String)"Access Token Type cannot be null or empty");
        this.expiresIn = expiresInDuration;
    }

    @Nonnull
    @NotEmpty
    public String getName() {
        return this.accessToken;
    }

    @Nonnull
    public String getAccessTokenType() {
        return this.accessTokenType;
    }

    @Nullable
    public Duration getExpiresIn() {
        return this.expiresIn;
    }

    public int hashCode() {
        return this.accessToken.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof OAuth2AccessTokenPrincipal) {
            OAuth2AccessTokenPrincipal principal = (OAuth2AccessTokenPrincipal)other;
            return this.accessToken.equals(principal.getName());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("access_token", (Object)this.accessToken).add("token_type", (Object)this.accessTokenType).add("expires_in", (Object)this.expiresIn).toString();
    }

    public OAuth2AccessTokenPrincipal clone() throws CloneNotSupportedException {
        OAuth2AccessTokenPrincipal copy = (OAuth2AccessTokenPrincipal)super.clone();
        copy.accessToken = this.accessToken;
        copy.accessTokenType = this.accessTokenType;
        copy.expiresIn = this.expiresIn;
        return copy;
    }
}

