/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.context.navigate;

import com.nimbusds.jose.Payload;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.slf4j.Logger;

public class PayloadFromRequestObjectLookupFunction
implements Function<MessageContext, Payload> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PayloadFromRequestObjectLookupFunction.class);
    @Nonnull
    private Function<MessageContext, OIDCAuthenticationRequest> authenticationRequestLookupStrategy = mc -> {
        Object patt1978$temp = mc.getMessage();
        if (patt1978$temp instanceof OIDCAuthenticationRequest) {
            OIDCAuthenticationRequest request = (OIDCAuthenticationRequest)patt1978$temp;
            return request;
        }
        return null;
    };

    public void setAuthenticationRequestLookupStrategy(@Nonnull Function<MessageContext, OIDCAuthenticationRequest> strategy) {
        this.authenticationRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthenticationRequestLookupStrategy lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public Payload apply(@Nullable MessageContext messageContext) {
        JWT requestObject;
        if (messageContext == null) {
            return null;
        }
        OIDCAuthenticationRequest authnRequest = this.authenticationRequestLookupStrategy.apply(messageContext);
        JWT jWT = requestObject = authnRequest != null ? authnRequest.getRequestObject() : null;
        if (requestObject instanceof SignedJWT) {
            SignedJWT signedJwt = (SignedJWT)requestObject;
            return new Payload(signedJwt);
        }
        if (requestObject instanceof PlainJWT) {
            try {
                return new Payload(requestObject.getJWTClaimsSet().getClaims());
            }
            catch (ParseException e) {
                this.log.error("Unable to convert plaintext JWT to claims set", (Throwable)e);
            }
        }
        return null;
    }
}

