/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.context.logic;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AbstractAuthenticatableOIDCContext;
import net.shibboleth.oidc.profile.config.OIDCAuthenticationRelyingPartyProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.messaging.AbstractRelyingPartyPredicate;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.ParentProfileRequestContextLookup;
import org.slf4j.Logger;

public class RequiresSignatureVerificationPredicate
extends AbstractRelyingPartyPredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RequiresSignatureVerificationPredicate.class);
    @Nonnull
    private final Function<MessageContext, AbstractAuthenticatableOIDCContext> authenticatableOIDCContextLookupStrategy;

    public RequiresSignatureVerificationPredicate(@Nonnull @ParameterName(name="authenticatableOIDCContextLookupStrategy") Function<MessageContext, AbstractAuthenticatableOIDCContext> strategy) {
        this.authenticatableOIDCContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"authenticatableOIDCContextLookupStrategy can not be null");
    }

    public boolean test(@Nullable MessageContext msgContext) {
        ProfileConfiguration profileConfiguration;
        ParentProfileRequestContextLookup lookup = new ParentProfileRequestContextLookup();
        ProfileRequestContext prc = (ProfileRequestContext)lookup.apply((BaseContext)msgContext);
        if (prc == null) {
            this.log.warn("Profile request context not found, signature verification will be requred");
            return true;
        }
        boolean tlsServerValidationOnly = false;
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(msgContext);
        if (rpc != null && (profileConfiguration = rpc.getProfileConfig()) instanceof OIDCAuthenticationRelyingPartyProfileConfiguration) {
            OIDCAuthenticationRelyingPartyProfileConfiguration rpConfig = (OIDCAuthenticationRelyingPartyProfileConfiguration)profileConfiguration;
            tlsServerValidationOnly = rpConfig.isTlsServerValidationSufficient(prc);
        }
        AbstractAuthenticatableOIDCContext authContext = this.authenticatableOIDCContextLookupStrategy.apply(msgContext);
        if (tlsServerValidationOnly && authContext.isAuthenticated()) {
            this.log.debug("TLS server validation was successful and sufficient, no further signature processing required");
            return false;
        }
        return true;
    }
}

