/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.context.logic;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.metadata.context.OIDCProviderMetadataContext;
import net.shibboleth.oidc.profile.config.OIDCAuthenticationRelyingPartyProfileConfiguration;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class RequestObjectRequiredAndSupported
extends AbstractRelyingPartyPredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RequestObjectRequiredAndSupported.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCProviderMetadataContext> oidcProviderMetadataContextLookupStrategy = new ChildContextLookup(OIDCProviderMetadataContext.class).compose((Function)new ChildContextLookup(OIDCPeerEntityContext.class)).compose(new InboundMessageContextLookup());

    public void setOidcProviderMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCProviderMetadataContext> strategy) {
        this.oidcProviderMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OidcProviderMetadataContextLookupStrategy lookup strategy cannot be null");
    }

    public boolean test(ProfileRequestContext input) {
        OIDCProviderMetadataContext metadata;
        OIDCProviderMetadata providerInformation;
        ProfileConfiguration profileConfiguration;
        boolean requestObjectRequestedFromConfig = false;
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null && (profileConfiguration = rpc.getProfileConfig()) instanceof OIDCAuthenticationRelyingPartyProfileConfiguration) {
            OIDCAuthenticationRelyingPartyProfileConfiguration rpConfig = (OIDCAuthenticationRelyingPartyProfileConfiguration)profileConfiguration;
            requestObjectRequestedFromConfig = rpConfig.isUseRequestObject(input);
        }
        OIDCProviderMetadata oIDCProviderMetadata = providerInformation = (metadata = this.oidcProviderMetadataContextLookupStrategy.apply(input)) != null ? metadata.getProviderInformation() : null;
        if (providerInformation == null) {
            this.log.warn("OIDC Provider Metadata is not available, can not determine if request object is supported, will not build request object");
            return false;
        }
        boolean isSupportedByOP = providerInformation.supportsRequestParam();
        boolean requestedAndSupport = requestObjectRequestedFromConfig && isSupportedByOP;
        this.log.debug("Authentication RequestObject was enabled '{}', is supported by the OP '{}', will be used '{}'", new Object[]{requestObjectRequestedFromConfig, isSupportedByOP, requestedAndSupport});
        return requestedAndSupport;
    }
}

