/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.context.logic;

import com.nimbusds.oauth2.sdk.ResponseType;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.slf4j.Logger;

public class IsImplicitFlowPredicate
implements Predicate<MessageContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IsImplicitFlowPredicate.class);

    @Override
    public boolean test(@Nullable MessageContext input) {
        if (input == null) {
            this.log.trace("Message context was null, can not determine flow type");
            return false;
        }
        Object object = input.getMessage();
        if (!(object instanceof OIDCAuthenticationRequest)) {
            this.log.trace("Message context did not contain an authentication request, can not determine flow type");
            return false;
        }
        OIDCAuthenticationRequest authnRequest = (OIDCAuthenticationRequest)object;
        ResponseType responseType = authnRequest.getResponseType();
        if (responseType == null) {
            this.log.trace("Authentication request did not contain a response_type, can not determine flow type");
            return false;
        }
        return responseType.impliesImplicitFlow();
    }
}

