/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.UserInfoResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate.AbstractUserInfoTokenResponseLookupStrategy;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class UserInfoInUserInfoResponseContextUpdateStrategy
extends AbstractUserInfoTokenResponseLookupStrategy
implements BiConsumer<ProfileRequestContext, JWT> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(UserInfoInUserInfoResponseContextUpdateStrategy.class);

    public UserInfoInUserInfoResponseContextUpdateStrategy(@ParameterName(name="userInfoResponseContextLookupStrategy") Function<ProfileRequestContext, UserInfoResponseContext> strategy) {
        super(strategy);
    }

    public UserInfoInUserInfoResponseContextUpdateStrategy() {
    }

    @Override
    public void accept(ProfileRequestContext profileRequestContext, JWT token) {
        UserInfoResponseContext context = this.getUserInfoResponseContextLookupStrategy().apply(profileRequestContext);
        if (context != null) {
            context.setUserInfo(new UserInfoSuccessResponse(token));
        } else {
            this.log.warn("Unable to set UserInfo back onto response context");
        }
    }
}

