/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.jwt.JWT;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.slf4j.Logger;

public class RequestObjectTokenUpdateStrategy
implements BiConsumer<JWT, MessageContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RequestObjectTokenUpdateStrategy.class);
    @Nonnull
    private Function<MessageContext, OIDCAuthenticationRequest> authenticationRequestLookupStrategy = mc -> {
        Object patt1754$temp = mc.getMessage();
        if (patt1754$temp instanceof OIDCAuthenticationRequest) {
            OIDCAuthenticationRequest request = (OIDCAuthenticationRequest)patt1754$temp;
            return request;
        }
        return null;
    };

    public void setAuthenticationRequestLookupStrategy(@Nonnull Function<MessageContext, OIDCAuthenticationRequest> strategy) {
        this.authenticationRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthenticationRequestLookupStrategy lookup strategy cannot be null");
    }

    @Override
    public void accept(@Nullable JWT jwt, @Nullable MessageContext messageContext) {
        if (messageContext == null) {
            return;
        }
        OIDCAuthenticationRequest authnRequest = this.authenticationRequestLookupStrategy.apply(messageContext);
        if (authnRequest != null) {
            authnRequest.setRequestObject(jwt);
        } else {
            this.log.warn("Unable to set JWT on OIDC authentication request, request was null");
        }
    }
}

