/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.jose.Header;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate.AbstractTokenResponseLookupStrategy;
import net.shibboleth.shared.annotation.ParameterName;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public class IDTokenJOSEHeaderLookupStrategy
extends AbstractTokenResponseLookupStrategy
implements Function<ProfileRequestContext, JWSHeader> {
    public IDTokenJOSEHeaderLookupStrategy() {
    }

    public IDTokenJOSEHeaderLookupStrategy(@Nonnull @ParameterName(name="accessTokenContextLookupStrategy") Function<ProfileRequestContext, AccessTokenResponseContext> strategy) {
        super(strategy);
    }

    @Override
    @Nullable
    public JWSHeader apply(@Nullable ProfileRequestContext prc) {
        OIDCTokenResponse tokenResponse;
        AccessTokenResponseContext tokenContext = this.getTokenResponseContextLookupStrategy().apply(prc);
        OIDCTokenResponse oIDCTokenResponse = tokenResponse = tokenContext != null ? tokenContext.getTokenResponse() : null;
        if (tokenResponse == null || tokenResponse.getOIDCTokens().getIDToken() == null) {
            return null;
        }
        Header header = tokenResponse.getOIDCTokens().getIDToken().getHeader();
        if (header instanceof JWSHeader) {
            JWSHeader jwsHeader = (JWSHeader)header;
            return jwsHeader;
        }
        return null;
    }
}

