/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.jwt.JWT;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.UserInfoResponseContext;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;

@ThreadSafe
public class DefaultUserInfoJWTLookupStrategy
implements Function<ProfileRequestContext, JWT> {
    @Nonnull
    private final Function<ProfileRequestContext, UserInfoResponseContext> userInfoResponseContextLookupStrategy;

    public DefaultUserInfoJWTLookupStrategy() {
        this.userInfoResponseContextLookupStrategy = new ChildContextLookup(UserInfoResponseContext.class).compose((Function)new InboundMessageContextLookup());
    }

    public DefaultUserInfoJWTLookupStrategy(@Nonnull Function<ProfileRequestContext, UserInfoResponseContext> strategy) {
        this.userInfoResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"UserInfoResponseContext lookup strategy can not be null");
    }

    @Override
    @Nullable
    public JWT apply(@Nullable ProfileRequestContext prc) {
        UserInfoSuccessResponse userInfo;
        UserInfoResponseContext userInfoContext = this.userInfoResponseContextLookupStrategy.apply(prc);
        UserInfoSuccessResponse userInfoSuccessResponse = userInfo = userInfoContext != null ? userInfoContext.getUserInfo() : null;
        if (userInfo == null || userInfo.getEntityContentType() != ContentType.APPLICATION_JWT) {
            return null;
        }
        return userInfo.getUserInfoJWT();
    }
}

