/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.EndUserClaimsContext;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;

@ThreadSafe
public class DefaultEndUserClaimsLookupStrategy
implements Function<ProfileRequestContext, ClaimsSet> {
    @Nonnull
    private final Function<ProfileRequestContext, EndUserClaimsContext> endUserClaimsContextLookupStrategy;

    public DefaultEndUserClaimsLookupStrategy(@Nullable @ParameterName(name="endUserClaimsContextLookupStrategy") Function<ProfileRequestContext, EndUserClaimsContext> strategy) {
        this.endUserClaimsContextLookupStrategy = strategy != null ? (Function)Constraint.isNotNull(strategy, (String)"EndUserClaimsContext lookup strategy can not be null") : new ChildContextLookup(EndUserClaimsContext.class).compose((Function)new InboundMessageContextLookup());
    }

    @Override
    @Nullable
    public ClaimsSet apply(@Nullable ProfileRequestContext prc) {
        EndUserClaimsContext endUserContext = this.endUserClaimsContextLookupStrategy.apply(prc);
        if (endUserContext != null && endUserContext.getEndUserClaims() != null) {
            return endUserContext.getEndUserClaims();
        }
        return null;
    }
}

