/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.OAuth2ClientContext;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public class ClientIDFromOAuth2ClientContextFunction
implements BiFunction<ProfileRequestContext, JWTClaimsSet, String> {
    @Nonnull
    private final Function<ProfileRequestContext, OAuth2ClientContext> oauth2ClientContextLookupStrategy;

    public ClientIDFromOAuth2ClientContextFunction(@Nonnull @ParameterName(name="oauth2ClientContextLookupStrategy") Function<ProfileRequestContext, OAuth2ClientContext> strgy) {
        this.oauth2ClientContextLookupStrategy = (Function)Constraint.isNotNull(strgy, (String)"OAuth2 client context lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext prc, @Nullable JWTClaimsSet claimsSet) {
        OAuth2ClientContext clientContext = this.oauth2ClientContextLookupStrategy.apply(prc);
        if (clientContext == null) {
            return null;
        }
        return clientContext.getClientId();
    }
}

