/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class AuthenticationRequestTimeLookupFunction
implements Function<ProfileRequestContext, Instant> {
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationRequest> authenticationRequestLookupStrategy = prc -> {
        Object outboundMessage = prc.ensureOutboundMessageContext().getMessage();
        if (outboundMessage instanceof OIDCAuthenticationRequest) {
            OIDCAuthenticationRequest authnRequest = (OIDCAuthenticationRequest)outboundMessage;
            return authnRequest;
        }
        return null;
    };
    @Nonnull
    private Duration clockSkew;

    public AuthenticationRequestTimeLookupFunction() {
        Duration ofSeconds = Duration.ofSeconds(0L);
        assert (ofSeconds != null);
        this.clockSkew = ofSeconds;
    }

    public void setClockSkew(@Nonnull Duration skew) {
        this.clockSkew = (Duration)Constraint.isNotNull((Object)skew, (String)"Clock skew cannot be null");
    }

    public void setAuthenticationRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationRequest> strategy) {
        this.authenticationRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthenticationRequestLookupStrategy lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public Instant apply(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return null;
        }
        OIDCAuthenticationRequest authnRequest = this.authenticationRequestLookupStrategy.apply(input);
        Instant authTime = authnRequest == null ? null : authnRequest.getAuthnRequestTime();
        return authTime == null ? null : authTime.minus(this.clockSkew);
    }
}

