/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.config.navigate;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class ProviderMetadataStringListValueLookupFunction
implements Function<OIDCProviderMetadata, List<String>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProviderMetadataStringListValueLookupFunction.class);
    @Nonnull
    private final String keyName;

    public ProviderMetadataStringListValueLookupFunction(@ParameterName(name="keyName") @Nonnull String name) {
        this.keyName = Constraint.isNotEmpty((String)name, (String)"The key name cannot be empty");
    }

    @Override
    @Nullable
    public List<String> apply(@Nullable OIDCProviderMetadata metadata) {
        if (metadata == null) {
            this.log.trace("No provider metadata available");
            return null;
        }
        Object value = metadata.toJSONObject().get((Object)this.keyName);
        if (value == null) {
            this.log.trace("No value found for the key {}", (Object)this.keyName);
            return null;
        }
        if (value instanceof String) {
            String strValue = (String)value;
            return List.of(strValue);
        }
        if (value instanceof List) {
            List valueAsList = (List)value;
            return Collections.unmodifiableList(valueAsList.stream().filter(Objects::nonNull).filter(String.class::isInstance).map(String.class::cast).filter(Predicate.not(String::isEmpty)).toList());
        }
        return null;
    }
}

