/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.security.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public class NonceValidationActivationCondition
implements BiPredicate<ProfileRequestContext, JWTClaimsSet> {
    @Nonnull
    private final Function<ProfileRequestContext, OIDCAuthenticationRequest> authenticationRequestLookupStrategy;

    public NonceValidationActivationCondition(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationRequest> strategy) {
        this.authenticationRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authentication request lookup strategy can not be null");
    }

    public NonceValidationActivationCondition() {
        this.authenticationRequestLookupStrategy = prc -> {
            Object patt2325$temp;
            MessageContext messageContext = prc.getOutboundMessageContext();
            if (messageContext != null && (patt2325$temp = messageContext.getMessage()) instanceof OIDCAuthenticationRequest) {
                OIDCAuthenticationRequest request = (OIDCAuthenticationRequest)patt2325$temp;
                return request;
            }
            return null;
        };
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext context, @Nullable JWTClaimsSet claims) {
        OIDCAuthenticationRequest request = this.authenticationRequestLookupStrategy.apply(context);
        if (request == null) {
            return false;
        }
        return request.getNonce() != null;
    }
}

